/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx;

import com.oracle.javafx.jmx.SGMXBean;
import com.oracle.javafx.jmx.json.JSONDocument;
import com.sun.javafx.jmx.HighlightRegion;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class SGMXBeanImpl
implements SGMXBean,
MXNodeAlgorithm {
    private static final String SGMX_NOT_PAUSED_TEXT = "Scene-graph is not PAUSED.";
    private static final String SGMX_CALL_GETSGTREE_FIRST = "You need to call getSGTree() first.";
    private boolean paused = false;
    private Map<Integer, Window> windowMap = null;
    private JSONDocument jwindows = null;
    private Map<Integer, Node> nodeMap = null;
    private JSONDocument[] jsceneGraphs = null;
    private Map<Scene, BufferedImage> scene2Image = null;
    private List<MediaPlayer> playersToResume = null;

    @Override
    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.releaseAllStateObject();
        Toolkit tk = Toolkit.getToolkit();
        tk.pauseScenes();
        this.pauseMedia();
    }

    @Override
    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.releaseAllStateObject();
        Toolkit tk = Toolkit.getToolkit();
        tk.resumeScenes();
        this.resumeMedia();
    }

    @Override
    public void step() throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.releaseAllStateObject();
        Toolkit tk = Toolkit.getToolkit();
        final CountDownLatch onePulseLatch = new CountDownLatch(1);
        tk.setLastTkPulseListener(new TKPulseListener(){

            public void pulse() {
                onePulseLatch.countDown();
            }
        });
        tk.resumeScenes();
        try {
            onePulseLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tk.pauseScenes();
        tk.setLastTkPulseListener(null);
    }

    @Override
    public String getWindows() throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.importWindowsIfNeeded();
        return this.jwindows.toJSON();
    }

    @Override
    public String getSGTree(int windowId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        this.importWindowsIfNeeded();
        if (this.nodeMap == null) {
            this.nodeMap = new LinkedHashMap<Integer, Node>();
        }
        if (this.jsceneGraphs[windowId] == null) {
            Window window = this.windowMap.get(windowId);
            this.importSGTree((Node)window.getScene().getRoot(), windowId);
        }
        return this.jsceneGraphs[windowId].toJSON();
    }

    @Override
    public void addHighlightedNode(int nodeId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        Toolkit.getToolkit().getHighlightedRegions().add(this.createHighlightRegion(nodeId));
        this.getNode(nodeId).getScene().impl_getPeer().markDirty();
    }

    @Override
    public void removeHighlightedNode(int nodeId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        Toolkit.getToolkit().getHighlightedRegions().remove(this.createHighlightRegion(nodeId));
        this.getNode(nodeId).getScene().impl_getPeer().markDirty();
    }

    @Override
    public void addHighlightedRegion(int windowId, double x, double y, double w, double h) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        TKScene scenePeer = this.getScene(windowId).impl_getPeer();
        Toolkit.getToolkit().getHighlightedRegions().add(new HighlightRegion(scenePeer, x, y, w, h));
        scenePeer.markDirty();
    }

    @Override
    public void removeHighlightedRegion(int windowId, double x, double y, double w, double h) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        TKScene scenePeer = this.getScene(windowId).impl_getPeer();
        Toolkit.getToolkit().getHighlightedRegions().remove(new HighlightRegion(scenePeer, x, y, w, h));
        scenePeer.markDirty();
    }

    private Node getNode(int nodeId) {
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("Wrong node id.");
        }
        return node;
    }

    private Scene getScene(int windowId) {
        if (this.windowMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Window window = this.windowMap.get(windowId);
        if (window == null) {
            throw new IllegalArgumentException("Wrong window id.");
        }
        return window.getScene();
    }

    private HighlightRegion createHighlightRegion(int nodeId) {
        Node node = this.getNode(nodeId);
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        return new HighlightRegion(node.getScene().impl_getPeer(), bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public String makeScreenShot(int nodeId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(nodeId);
        if (node == null) {
            return null;
        }
        Scene scene = node.getScene();
        Bounds sceneBounds = node.localToScene(node.getBoundsInLocal());
        return this.getScreenShotPath(scene, sceneBounds.getMinX(), sceneBounds.getMinY(), sceneBounds.getWidth(), sceneBounds.getHeight());
    }

    @Override
    public String makeScreenShot(int windowId, double x, double y, double w, double h) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Scene scene = this.getScene(windowId);
        return this.getScreenShotPath(scene, x, y, w, h);
    }

    private String getScreenShotPath(Scene scene, double x, double y, double w, double h) {
        BufferedImage bufferedImage;
        if (this.scene2Image == null) {
            this.scene2Image = new LinkedHashMap<Scene, BufferedImage>();
        }
        if ((bufferedImage = this.scene2Image.get(scene)) == null) {
            WritableImage fxImage = scene.snapshot(null);
            bufferedImage = SwingFXUtils.fromFXImage((Image)fxImage, null);
            this.scene2Image.put(scene, bufferedImage);
        }
        BufferedImage nodeImage = bufferedImage.getSubimage((int)x, (int)y, (int)w, (int)h);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("jfx", ".png");
            ImageIO.write((RenderedImage)nodeImage, "PNG", tmpFile);
            tmpFile.deleteOnExit();
            return tmpFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void releaseAllStateObject() {
        this.clearWindowMap();
        this.jwindows = null;
        this.clearNodeMap();
        this.jsceneGraphs = null;
        this.clearScene2Image();
    }

    private void clearWindowMap() {
        if (this.windowMap != null) {
            this.windowMap.clear();
            this.windowMap = null;
        }
    }

    private void clearNodeMap() {
        if (this.nodeMap != null) {
            this.nodeMap.clear();
            this.nodeMap = null;
        }
    }

    private void clearScene2Image() {
        if (this.scene2Image != null) {
            this.scene2Image.clear();
            this.scene2Image = null;
        }
    }

    private void importWindowsIfNeeded() {
        if (this.windowMap == null) {
            this.windowMap = new LinkedHashMap<Integer, Window>();
            this.importWindows();
        }
    }

    private void importWindows() {
        int windowCount = 0;
        Iterator it = Window.impl_getWindows();
        this.jwindows = JSONDocument.createArray();
        while (it.hasNext()) {
            Window window = (Window)it.next();
            this.windowMap.put(windowCount, window);
            JSONDocument jwindow = JSONDocument.createObject();
            jwindow.setNumber("id", (Number)windowCount);
            jwindow.setString("type", window.impl_getMXWindowType());
            this.jwindows.array().add(jwindow);
            ++windowCount;
        }
        this.jsceneGraphs = new JSONDocument[windowCount];
    }

    private void importSGTree(Node sgRoot, int windowId) {
        if (sgRoot == null) {
            return;
        }
        this.jsceneGraphs[windowId] = (JSONDocument)sgRoot.impl_processMXNode((MXNodeAlgorithm)this, new MXNodeAlgorithmContext(this.nodeMap.size()));
    }

    @Override
    public String getCSSInfo(int nodeId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(nodeId);
        if (node == null) {
            return null;
        }
        JSONDocument d = new JSONDocument(JSONDocument.Type.OBJECT);
        List styleables = node.getCssMetaData();
        for (CssMetaData sp : styleables) {
            SGMXBeanImpl.processCssMetaData(sp, node, d);
        }
        return d.toJSON();
    }

    private static void processCssMetaData(CssMetaData sp, Node node, JSONDocument d) {
        List subProps = sp.getSubProperties();
        if (subProps != null && !subProps.isEmpty()) {
            for (CssMetaData subSp : subProps) {
                SGMXBeanImpl.processCssMetaData(subSp, node, d);
            }
        }
        try {
            Object value;
            StyleableProperty writable = sp.getStyleableProperty((Styleable)node);
            Object object = value = writable != null ? writable.getValue() : null;
            if (value != null) {
                d.setString(sp.getProperty(), value.toString());
            } else {
                d.setString(sp.getProperty(), "null");
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static String upcaseFirstLetter(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    @Override
    public String getBounds(int nodeId) throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException(SGMX_NOT_PAUSED_TEXT);
        }
        if (this.nodeMap == null) {
            throw new IllegalStateException(SGMX_CALL_GETSGTREE_FIRST);
        }
        Node node = this.nodeMap.get(nodeId);
        if (node == null) {
            return null;
        }
        Bounds sceneBounds = node.localToScene(node.getBoundsInLocal());
        JSONDocument d = JSONDocument.createObject();
        d.setNumber("x", (Number)sceneBounds.getMinX());
        d.setNumber("y", (Number)sceneBounds.getMinY());
        d.setNumber("w", (Number)sceneBounds.getWidth());
        d.setNumber("h", (Number)sceneBounds.getHeight());
        return d.toJSON();
    }

    public Object processLeafNode(Node node, MXNodeAlgorithmContext ctx) {
        return this.createJSONDocument(node, ctx);
    }

    public Object processContainerNode(Parent parent, MXNodeAlgorithmContext ctx) {
        JSONDocument d = this.createJSONDocument((Node)parent, ctx);
        ObservableList children = parent.getChildrenUnmodifiable();
        JSONDocument childrenDoc = JSONDocument.createArray(children.size());
        d.set("children", childrenDoc);
        for (int i = 0; i < children.size(); ++i) {
            childrenDoc.set(i, (JSONDocument)((Node)children.get(i)).impl_processMXNode((MXNodeAlgorithm)this, ctx));
        }
        return d;
    }

    private JSONDocument createJSONDocument(Node n, MXNodeAlgorithmContext ctx) {
        int id = ctx.getNextInt();
        this.nodeMap.put(id, n);
        JSONDocument d = JSONDocument.createObject();
        d.setNumber("id", (Number)id);
        d.setString("class", n.getClass().getSimpleName());
        return d;
    }

    private void pauseMedia() {
        AudioClip.stopAllClips();
        List allPlayers = MediaManager.getAllMediaPlayers();
        if (allPlayers == null) {
            return;
        }
        if (!allPlayers.isEmpty() && this.playersToResume == null) {
            this.playersToResume = new ArrayList<MediaPlayer>();
        }
        for (MediaPlayer player : allPlayers) {
            if (player.getState() != PlayerStateEvent.PlayerState.PLAYING) continue;
            player.pause();
            this.playersToResume.add(player);
        }
    }

    private void resumeMedia() {
        if (this.playersToResume == null) {
            return;
        }
        for (MediaPlayer player : this.playersToResume) {
            player.play();
        }
        this.playersToResume.clear();
    }
}

