/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import javax.swing.SwingUtilities;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.awt.dnd.SunDropTargetEvent;
import sun.lwawt.macosx.LWCToolkit;

final class CDropTargetContextPeer
extends SunDropTargetContextPeer {
    private long fNativeDropTransfer = 0L;
    private long fNativeDataAvailable = 0L;
    private Object fNativeData = null;
    private DropTarget insideTarget = null;
    Object awtLockAccess = new Object();

    static CDropTargetContextPeer getDropTargetContextPeer() {
        return new CDropTargetContextPeer();
    }

    private CDropTargetContextPeer() {
    }

    private void flushEvents(Component component) {
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                @Override
                public synchronized void run() {
                }
            }, component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getNativeData(long l) {
        long l2 = this.getNativeDragContext();
        Object object = this.awtLockAccess;
        synchronized (object) {
            this.fNativeDataAvailable = 0L;
            if (this.fNativeDropTransfer == 0L) {
                this.fNativeDropTransfer = this.startTransfer(l2, l);
            } else {
                this.addTransfer(l2, this.fNativeDropTransfer, l);
            }
            while (l != this.fNativeDataAvailable) {
                try {
                    this.awtLockAccess.wait();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return this.fNativeData;
    }

    @Override
    protected void processMotionMessage(SunDropTargetEvent sunDropTargetEvent, boolean bl) {
        boolean bl2 = this.isEventInsideTarget(sunDropTargetEvent);
        if (sunDropTargetEvent.getComponent().getDropTarget() == this.insideTarget) {
            if (!bl2) {
                this.processExitMessage(sunDropTargetEvent);
                return;
            }
        } else if (bl2) {
            this.processEnterMessage(sunDropTargetEvent);
        } else {
            return;
        }
        super.processMotionMessage(sunDropTargetEvent, bl);
    }

    @Override
    protected void processEnterMessage(SunDropTargetEvent sunDropTargetEvent) {
        Component component = sunDropTargetEvent.getComponent();
        DropTarget dropTarget = sunDropTargetEvent.getComponent().getDropTarget();
        if (this.isEventInsideTarget(sunDropTargetEvent) && dropTarget != this.insideTarget && component.isShowing() && dropTarget != null && dropTarget.isActive()) {
            this.insideTarget = dropTarget;
            super.processEnterMessage(sunDropTargetEvent);
        }
    }

    @Override
    protected void processExitMessage(SunDropTargetEvent sunDropTargetEvent) {
        if (sunDropTargetEvent.getComponent().getDropTarget() == this.insideTarget) {
            this.insideTarget = null;
            super.processExitMessage(sunDropTargetEvent);
        }
    }

    @Override
    protected void processDropMessage(SunDropTargetEvent sunDropTargetEvent) {
        if (this.isEventInsideTarget(sunDropTargetEvent)) {
            super.processDropMessage(sunDropTargetEvent);
            this.insideTarget = null;
        }
    }

    private boolean isEventInsideTarget(SunDropTargetEvent sunDropTargetEvent) {
        Component component = sunDropTargetEvent.getComponent();
        Point point = sunDropTargetEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, component);
        Point point2 = component.getLocationOnScreen();
        Rectangle rectangle = new Rectangle(point2.x, point2.y, component.getWidth(), component.getHeight());
        return rectangle.contains(point);
    }

    @Override
    protected int postDropTargetEvent(Component component, int n, int n2, int n3, int n4, long[] lArray, long l, int n5, boolean bl) {
        return super.postDropTargetEvent(component, n, n2, n3, n4, lArray, l, n5, true);
    }

    @Override
    protected void doDropDone(boolean bl, int n, boolean bl2) {
        long l = this.getNativeDragContext();
        this.dropDone(l, this.fNativeDropTransfer, bl2, bl, n);
    }

    private void newData(long l, byte[] byArray) {
        this.fNativeDataAvailable = l;
        this.fNativeData = byArray;
        this.awtLockAccess.notifyAll();
    }

    private void transferFailed(long l) {
        this.fNativeDataAvailable = l;
        this.fNativeData = null;
        this.awtLockAccess.notifyAll();
    }

    private native long startTransfer(long var1, long var3);

    private native void addTransfer(long var1, long var3, long var5);

    private native void dropDone(long var1, long var3, boolean var5, boolean var6, int var7);
}

