/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class SortHelper {
    private int[] permutation;
    private int[] reversePermutation;
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public <T extends Comparable<? super T>> int[] sort(List<T> list) {
        Comparable[] a = (Comparable[])Array.newInstance(Comparable.class, list.size());
        try {
            a = list.toArray(a);
        }
        catch (ArrayStoreException e) {
            throw new ClassCastException();
        }
        int[] result = this.sort(a);
        ListIterator<T> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
        return result;
    }

    public <T> int[] sort(List<T> list, Comparator<? super T> c) {
        Object[] a = list.toArray();
        int[] result = this.sort(a, c);
        ListIterator<T> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
        return result;
    }

    public <T extends Comparable<? super T>> int[] sort(T[] a) {
        return this.sort(a, null);
    }

    public <T> int[] sort(T[] a, Comparator<? super T> c) {
        Object[] aux = (Object[])a.clone();
        int[] result = this.initPermutation(a.length);
        if (c == null) {
            this.mergeSort(aux, a, 0, a.length, 0);
        } else {
            this.mergeSort(aux, a, 0, a.length, 0, c);
        }
        this.reversePermutation = null;
        this.permutation = null;
        return result;
    }

    public <T> int[] sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        SortHelper.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = SortHelper.copyOfRange(a, fromIndex, toIndex);
        int[] result = this.initPermutation(a.length);
        if (c == null) {
            this.mergeSort(aux, a, fromIndex, toIndex, -fromIndex);
        } else {
            this.mergeSort(aux, a, fromIndex, toIndex, -fromIndex, c);
        }
        this.reversePermutation = null;
        this.permutation = null;
        return Arrays.copyOfRange(result, fromIndex, toIndex);
    }

    public int[] sort(int[] a, int fromIndex, int toIndex) {
        SortHelper.rangeCheck(a.length, fromIndex, toIndex);
        int[] aux = SortHelper.copyOfRange(a, fromIndex, toIndex);
        int[] result = this.initPermutation(a.length);
        this.mergeSort(aux, a, fromIndex, toIndex, -fromIndex);
        this.reversePermutation = null;
        this.permutation = null;
        return Arrays.copyOfRange(result, fromIndex, toIndex);
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static int[] copyOfRange(int[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        int[] copy = new int[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private static <T> T[] copyOfRange(T[] original, int from, int to) {
        return SortHelper.copyOfRange(original, from, to, original.getClass());
    }

    private static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private void mergeSort(int[] src, int[] dest, int low, int high, int off) {
        int i;
        int length = high - low;
        if (length < 7) {
            for (int i2 = low; i2 < high; ++i2) {
                for (int j = i2; j > low && Integer.valueOf(dest[j - 1]).compareTo(dest[j]) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        this.mergeSort(dest, src, low, mid, -off);
        this.mergeSort(dest, src, mid, high, -off);
        if (Integer.valueOf(src[mid - 1]).compareTo(src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (i = destLow; i < destHigh; ++i) {
            if (q >= high || p < mid && Integer.valueOf(src[p]).compareTo(src[q]) <= 0) {
                dest[i] = src[p];
                this.permutation[this.reversePermutation[p++]] = i;
                continue;
            }
            dest[i] = src[q];
            this.permutation[this.reversePermutation[q++]] = i;
        }
        for (i = destLow; i < destHigh; ++i) {
            this.reversePermutation[this.permutation[i]] = i;
        }
    }

    private void mergeSort(Object[] src, Object[] dest, int low, int high, int off) {
        int i;
        int length = high - low;
        if (length < 7) {
            for (int i2 = low; i2 < high; ++i2) {
                for (int j = i2; j > low && ((Comparable)dest[j - 1]).compareTo(dest[j]) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        this.mergeSort(dest, src, low, mid, -off);
        this.mergeSort(dest, src, mid, high, -off);
        if (((Comparable)src[mid - 1]).compareTo(src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (i = destLow; i < destHigh; ++i) {
            if (q >= high || p < mid && ((Comparable)src[p]).compareTo(src[q]) <= 0) {
                dest[i] = src[p];
                this.permutation[this.reversePermutation[p++]] = i;
                continue;
            }
            dest[i] = src[q];
            this.permutation[this.reversePermutation[q++]] = i;
        }
        for (i = destLow; i < destHigh; ++i) {
            this.reversePermutation[this.permutation[i]] = i;
        }
    }

    private void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator c) {
        int i;
        int length = high - low;
        if (length < 7) {
            for (int i2 = low; i2 < high; ++i2) {
                for (int j = i2; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        this.mergeSort(dest, src, low, mid, -off, c);
        this.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (i = destLow; i < destHigh; ++i) {
            if (q >= high || p < mid && c.compare(src[p], src[q]) <= 0) {
                dest[i] = src[p];
                this.permutation[this.reversePermutation[p++]] = i;
                continue;
            }
            dest[i] = src[q];
            this.permutation[this.reversePermutation[q++]] = i;
        }
        for (i = destLow; i < destHigh; ++i) {
            this.reversePermutation[this.permutation[i]] = i;
        }
    }

    private void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
        this.permutation[this.reversePermutation[a]] = b;
        this.permutation[this.reversePermutation[b]] = a;
        int tp = this.reversePermutation[a];
        this.reversePermutation[a] = this.reversePermutation[b];
        this.reversePermutation[b] = tp;
    }

    private void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
        this.permutation[this.reversePermutation[a]] = b;
        this.permutation[this.reversePermutation[b]] = a;
        int tp = this.reversePermutation[a];
        this.reversePermutation[a] = this.reversePermutation[b];
        this.reversePermutation[b] = tp;
    }

    private int[] initPermutation(int length) {
        this.permutation = new int[length];
        this.reversePermutation = new int[length];
        for (int i = 0; i < length; ++i) {
            this.permutation[i] = this.reversePermutation[i] = i;
        }
        return this.permutation;
    }
}

