/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.Spinner;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public abstract class SpinnerValueFactory<T> {
    private ObjectProperty<T> value = new SimpleObjectProperty(this, "value");
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");
    private BooleanProperty wrapAround;

    public abstract void decrement(int var1);

    public abstract void increment(int var1);

    public final T getValue() {
        return this.value.get();
    }

    public final void setValue(T newValue) {
        this.value.set(newValue);
    }

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final void setConverter(StringConverter<T> newValue) {
        this.converter.set(newValue);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setWrapAround(boolean value) {
        this.wrapAroundProperty().set(value);
    }

    public final boolean isWrapAround() {
        return this.wrapAround == null ? false : this.wrapAround.get();
    }

    public final BooleanProperty wrapAroundProperty() {
        if (this.wrapAround == null) {
            this.wrapAround = new SimpleBooleanProperty(this, "wrapAround", false);
        }
        return this.wrapAround;
    }

    static class LocalTimeSpinnerValueFactory
    extends SpinnerValueFactory<LocalTime> {
        private ObjectProperty<LocalTime> min = new SimpleObjectProperty<LocalTime>((Object)this, "min"){

            @Override
            protected void invalidated() {
                LocalTime currentValue = (LocalTime)this.getValue();
                if (currentValue == null) {
                    return;
                }
                LocalTime newMin = (LocalTime)this.get();
                if (newMin.isAfter(this.getMax())) {
                    this.setMin(this.getMax());
                    return;
                }
                if (currentValue.isBefore(newMin)) {
                    this.setValue(newMin);
                }
            }
        };
        private ObjectProperty<LocalTime> max = new SimpleObjectProperty<LocalTime>((Object)this, "max"){

            @Override
            protected void invalidated() {
                LocalTime currentValue = (LocalTime)this.getValue();
                if (currentValue == null) {
                    return;
                }
                LocalTime newMax = (LocalTime)this.get();
                if (newMax.isBefore(this.getMin())) {
                    this.setMax(this.getMin());
                    return;
                }
                if (currentValue.isAfter(newMax)) {
                    this.setValue(newMax);
                }
            }
        };
        private ObjectProperty<TemporalUnit> temporalUnit = new SimpleObjectProperty<TemporalUnit>(this, "temporalUnit");
        private LongProperty amountToStepBy = new SimpleLongProperty(this, "amountToStepBy");

        public LocalTimeSpinnerValueFactory() {
            this(LocalTime.now());
        }

        public LocalTimeSpinnerValueFactory(@NamedArg(value="initialValue") LocalTime initialValue) {
            this(LocalTime.MIN, LocalTime.MAX, initialValue);
        }

        public LocalTimeSpinnerValueFactory(@NamedArg(value="min") LocalTime min, @NamedArg(value="min") LocalTime max, @NamedArg(value="initialValue") LocalTime initialValue) {
            this(min, max, initialValue, 1L, ChronoUnit.HOURS);
        }

        public LocalTimeSpinnerValueFactory(@NamedArg(value="min") LocalTime min, @NamedArg(value="min") LocalTime max, @NamedArg(value="initialValue") LocalTime initialValue, @NamedArg(value="amountToStepBy") long amountToStepBy, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
            this.setMin(min);
            this.setMax(max);
            this.setAmountToStepBy(amountToStepBy);
            this.setTemporalUnit(temporalUnit);
            this.setConverter(new StringConverter<LocalTime>(){
                private DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);

                @Override
                public String toString(LocalTime localTime) {
                    if (localTime == null) {
                        return "";
                    }
                    return localTime.format(this.dtf);
                }

                @Override
                public LocalTime fromString(String string) {
                    return LocalTime.parse(string);
                }
            });
            this.valueProperty().addListener((o, oldValue, newValue) -> {
                if (this.getMin() != null && newValue.isBefore(this.getMin())) {
                    this.setValue(this.getMin());
                } else if (this.getMax() != null && newValue.isAfter(this.getMax())) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(initialValue != null ? initialValue : LocalTime.now());
        }

        public final void setMin(LocalTime value) {
            this.min.set(value);
        }

        public final LocalTime getMin() {
            return (LocalTime)this.min.get();
        }

        public final ObjectProperty<LocalTime> minProperty() {
            return this.min;
        }

        public final void setMax(LocalTime value) {
            this.max.set(value);
        }

        public final LocalTime getMax() {
            return (LocalTime)this.max.get();
        }

        public final ObjectProperty<LocalTime> maxProperty() {
            return this.max;
        }

        public final void setTemporalUnit(TemporalUnit value) {
            this.temporalUnit.set(value);
        }

        public final TemporalUnit getTemporalUnit() {
            return (TemporalUnit)this.temporalUnit.get();
        }

        public final ObjectProperty<TemporalUnit> temporalUnitProperty() {
            return this.temporalUnit;
        }

        public final void setAmountToStepBy(long value) {
            this.amountToStepBy.set(value);
        }

        public final long getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final LongProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int steps) {
            LocalTime currentValue = (LocalTime)this.getValue();
            LocalTime min = this.getMin();
            Duration duration = Duration.of(this.getAmountToStepBy() * (long)steps, this.getTemporalUnit());
            long durationInSeconds = duration.toMinutes() * 60L;
            long currentValueInSeconds = currentValue.toSecondOfDay();
            if (!this.isWrapAround() && durationInSeconds > currentValueInSeconds) {
                this.setValue(min == null ? LocalTime.MIN : min);
            } else {
                this.setValue(currentValue.minus(duration));
            }
        }

        @Override
        public void increment(int steps) {
            LocalTime currentValue = (LocalTime)this.getValue();
            LocalTime max = this.getMax();
            Duration duration = Duration.of(this.getAmountToStepBy() * (long)steps, this.getTemporalUnit());
            long durationInSeconds = duration.toMinutes() * 60L;
            long currentValueInSeconds = currentValue.toSecondOfDay();
            if (!this.isWrapAround() && durationInSeconds > (long)LocalTime.MAX.toSecondOfDay() - currentValueInSeconds) {
                this.setValue(max == null ? LocalTime.MAX : max);
            } else {
                this.setValue(currentValue.plus(duration));
            }
        }
    }

    static class LocalDateSpinnerValueFactory
    extends SpinnerValueFactory<LocalDate> {
        private ObjectProperty<LocalDate> min = new SimpleObjectProperty<LocalDate>((Object)this, "min"){

            @Override
            protected void invalidated() {
                LocalDate currentValue = (LocalDate)this.getValue();
                if (currentValue == null) {
                    return;
                }
                LocalDate newMin = (LocalDate)this.get();
                if (newMin.isAfter(this.getMax())) {
                    this.setMin(this.getMax());
                    return;
                }
                if (currentValue.isBefore(newMin)) {
                    this.setValue(newMin);
                }
            }
        };
        private ObjectProperty<LocalDate> max = new SimpleObjectProperty<LocalDate>((Object)this, "max"){

            @Override
            protected void invalidated() {
                LocalDate currentValue = (LocalDate)this.getValue();
                if (currentValue == null) {
                    return;
                }
                LocalDate newMax = (LocalDate)this.get();
                if (newMax.isBefore(this.getMin())) {
                    this.setMax(this.getMin());
                    return;
                }
                if (currentValue.isAfter(newMax)) {
                    this.setValue(newMax);
                }
            }
        };
        private ObjectProperty<TemporalUnit> temporalUnit = new SimpleObjectProperty<TemporalUnit>(this, "temporalUnit");
        private LongProperty amountToStepBy = new SimpleLongProperty(this, "amountToStepBy");

        public LocalDateSpinnerValueFactory() {
            this(LocalDate.now());
        }

        public LocalDateSpinnerValueFactory(@NamedArg(value="initialValue") LocalDate initialValue) {
            this(LocalDate.MIN, LocalDate.MAX, initialValue);
        }

        public LocalDateSpinnerValueFactory(@NamedArg(value="min") LocalDate min, @NamedArg(value="min") LocalDate max, @NamedArg(value="initialValue") LocalDate initialValue) {
            this(min, max, initialValue, 1L, ChronoUnit.DAYS);
        }

        public LocalDateSpinnerValueFactory(@NamedArg(value="min") LocalDate min, @NamedArg(value="min") LocalDate max, @NamedArg(value="initialValue") LocalDate initialValue, @NamedArg(value="amountToStepBy") long amountToStepBy, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
            this.setMin(min);
            this.setMax(max);
            this.setAmountToStepBy(amountToStepBy);
            this.setTemporalUnit(temporalUnit);
            this.setConverter(new StringConverter<LocalDate>(){

                @Override
                public String toString(LocalDate object) {
                    if (object == null) {
                        return "";
                    }
                    return object.toString();
                }

                @Override
                public LocalDate fromString(String string) {
                    return LocalDate.parse(string);
                }
            });
            this.valueProperty().addListener((o, oldValue, newValue) -> {
                if (this.getMin() != null && newValue.isBefore(this.getMin())) {
                    this.setValue(this.getMin());
                } else if (this.getMax() != null && newValue.isAfter(this.getMax())) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(initialValue != null ? initialValue : LocalDate.now());
        }

        public final void setMin(LocalDate value) {
            this.min.set(value);
        }

        public final LocalDate getMin() {
            return (LocalDate)this.min.get();
        }

        public final ObjectProperty<LocalDate> minProperty() {
            return this.min;
        }

        public final void setMax(LocalDate value) {
            this.max.set(value);
        }

        public final LocalDate getMax() {
            return (LocalDate)this.max.get();
        }

        public final ObjectProperty<LocalDate> maxProperty() {
            return this.max;
        }

        public final void setTemporalUnit(TemporalUnit value) {
            this.temporalUnit.set(value);
        }

        public final TemporalUnit getTemporalUnit() {
            return (TemporalUnit)this.temporalUnit.get();
        }

        public final ObjectProperty<TemporalUnit> temporalUnitProperty() {
            return this.temporalUnit;
        }

        public final void setAmountToStepBy(long value) {
            this.amountToStepBy.set(value);
        }

        public final long getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final LongProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int steps) {
            LocalDate currentValue = (LocalDate)this.getValue();
            LocalDate min = this.getMin();
            LocalDate newValue = currentValue.minus(this.getAmountToStepBy() * (long)steps, this.getTemporalUnit());
            if (min != null && this.isWrapAround() && newValue.isBefore(min)) {
                newValue = this.getMax();
            }
            this.setValue(newValue);
        }

        @Override
        public void increment(int steps) {
            LocalDate currentValue = (LocalDate)this.getValue();
            LocalDate max = this.getMax();
            LocalDate newValue = currentValue.plus(this.getAmountToStepBy() * (long)steps, this.getTemporalUnit());
            if (max != null && this.isWrapAround() && newValue.isAfter(max)) {
                newValue = this.getMin();
            }
            this.setValue(newValue);
        }
    }

    public static class DoubleSpinnerValueFactory
    extends SpinnerValueFactory<Double> {
        private DoubleProperty min = new SimpleDoubleProperty(this, "min"){

            @Override
            protected void invalidated() {
                Double currentValue = (Double)this.getValue();
                if (currentValue == null) {
                    return;
                }
                double newMin = this.get();
                if (newMin > this.getMax()) {
                    this.setMin(this.getMax());
                    return;
                }
                if (currentValue < newMin) {
                    this.setValue(newMin);
                }
            }
        };
        private DoubleProperty max = new SimpleDoubleProperty(this, "max"){

            @Override
            protected void invalidated() {
                Double currentValue = (Double)this.getValue();
                if (currentValue == null) {
                    return;
                }
                double newMax = this.get();
                if (newMax < this.getMin()) {
                    this.setMax(this.getMin());
                    return;
                }
                if (currentValue > newMax) {
                    this.setValue(newMax);
                }
            }
        };
        private DoubleProperty amountToStepBy = new SimpleDoubleProperty(this, "amountToStepBy");

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max) {
            this(min, max, min);
        }

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue) {
            this(min, max, initialValue, 1.0);
        }

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue, @NamedArg(value="amountToStepBy") double amountToStepBy) {
            this.setMin(min);
            this.setMax(max);
            this.setAmountToStepBy(amountToStepBy);
            this.setConverter(new StringConverter<Double>(){
                private final DecimalFormat df = new DecimalFormat("#.##");

                @Override
                public String toString(Double value) {
                    if (value == null) {
                        return "";
                    }
                    return this.df.format(value);
                }

                @Override
                public Double fromString(String value) {
                    try {
                        if (value == null) {
                            return null;
                        }
                        if ((value = value.trim()).length() < 1) {
                            return null;
                        }
                        return this.df.parse(value).doubleValue();
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.valueProperty().addListener((o, oldValue, newValue) -> {
                if (newValue < this.getMin()) {
                    this.setValue(this.getMin());
                } else if (newValue > this.getMax()) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(initialValue >= min && initialValue <= max ? initialValue : min);
        }

        public final void setMin(double value) {
            this.min.set(value);
        }

        public final double getMin() {
            return this.min.get();
        }

        public final DoubleProperty minProperty() {
            return this.min;
        }

        public final void setMax(double value) {
            this.max.set(value);
        }

        public final double getMax() {
            return this.max.get();
        }

        public final DoubleProperty maxProperty() {
            return this.max;
        }

        public final void setAmountToStepBy(double value) {
            this.amountToStepBy.set(value);
        }

        public final double getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final DoubleProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int steps) {
            BigDecimal currentValue = BigDecimal.valueOf((Double)this.getValue());
            BigDecimal minBigDecimal = BigDecimal.valueOf(this.getMin());
            BigDecimal maxBigDecimal = BigDecimal.valueOf(this.getMax());
            BigDecimal amountToStepByBigDecimal = BigDecimal.valueOf(this.getAmountToStepBy());
            BigDecimal newValue = currentValue.subtract(amountToStepByBigDecimal.multiply(BigDecimal.valueOf(steps)));
            this.setValue(newValue.compareTo(minBigDecimal) >= 0 ? newValue.doubleValue() : (this.isWrapAround() ? Spinner.wrapValue(newValue, minBigDecimal, maxBigDecimal).doubleValue() : this.getMin()));
        }

        @Override
        public void increment(int steps) {
            BigDecimal currentValue = BigDecimal.valueOf((Double)this.getValue());
            BigDecimal minBigDecimal = BigDecimal.valueOf(this.getMin());
            BigDecimal maxBigDecimal = BigDecimal.valueOf(this.getMax());
            BigDecimal amountToStepByBigDecimal = BigDecimal.valueOf(this.getAmountToStepBy());
            BigDecimal newValue = currentValue.add(amountToStepByBigDecimal.multiply(BigDecimal.valueOf(steps)));
            this.setValue(newValue.compareTo(maxBigDecimal) <= 0 ? newValue.doubleValue() : (this.isWrapAround() ? Spinner.wrapValue(newValue, minBigDecimal, maxBigDecimal).doubleValue() : this.getMax()));
        }
    }

    public static class IntegerSpinnerValueFactory
    extends SpinnerValueFactory<Integer> {
        private IntegerProperty min = new SimpleIntegerProperty(this, "min"){

            @Override
            protected void invalidated() {
                Integer currentValue = (Integer)this.getValue();
                if (currentValue == null) {
                    return;
                }
                int newMin = this.get();
                if (newMin > this.getMax()) {
                    this.setMin(this.getMax());
                    return;
                }
                if (currentValue < newMin) {
                    this.setValue(newMin);
                }
            }
        };
        private IntegerProperty max = new SimpleIntegerProperty(this, "max"){

            @Override
            protected void invalidated() {
                Integer currentValue = (Integer)this.getValue();
                if (currentValue == null) {
                    return;
                }
                int newMax = this.get();
                if (newMax < this.getMin()) {
                    this.setMax(this.getMin());
                    return;
                }
                if (currentValue > newMax) {
                    this.setValue(newMax);
                }
            }
        };
        private IntegerProperty amountToStepBy = new SimpleIntegerProperty(this, "amountToStepBy");

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int min, @NamedArg(value="max") int max) {
            this(min, max, min);
        }

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int min, @NamedArg(value="max") int max, @NamedArg(value="initialValue") int initialValue) {
            this(min, max, initialValue, 1);
        }

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int min, @NamedArg(value="max") int max, @NamedArg(value="initialValue") int initialValue, @NamedArg(value="amountToStepBy") int amountToStepBy) {
            this.setMin(min);
            this.setMax(max);
            this.setAmountToStepBy(amountToStepBy);
            this.setConverter(new IntegerStringConverter());
            this.valueProperty().addListener((o, oldValue, newValue) -> {
                if (newValue < this.getMin()) {
                    this.setValue(this.getMin());
                } else if (newValue > this.getMax()) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(initialValue >= min && initialValue <= max ? initialValue : min);
        }

        public final void setMin(int value) {
            this.min.set(value);
        }

        public final int getMin() {
            return this.min.get();
        }

        public final IntegerProperty minProperty() {
            return this.min;
        }

        public final void setMax(int value) {
            this.max.set(value);
        }

        public final int getMax() {
            return this.max.get();
        }

        public final IntegerProperty maxProperty() {
            return this.max;
        }

        public final void setAmountToStepBy(int value) {
            this.amountToStepBy.set(value);
        }

        public final int getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final IntegerProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int steps) {
            int min = this.getMin();
            int max = this.getMax();
            int newIndex = (Integer)this.getValue() - steps * this.getAmountToStepBy();
            this.setValue(newIndex >= min ? newIndex : (this.isWrapAround() ? Spinner.wrapValue(newIndex, min, max) + 1 : min));
        }

        @Override
        public void increment(int steps) {
            int min = this.getMin();
            int max = this.getMax();
            int currentValue = (Integer)this.getValue();
            int newIndex = currentValue + steps * this.getAmountToStepBy();
            this.setValue(newIndex <= max ? newIndex : (this.isWrapAround() ? Spinner.wrapValue(newIndex, min, max) - 1 : max));
        }
    }

    public static class ListSpinnerValueFactory<T>
    extends SpinnerValueFactory<T> {
        private int currentIndex = 0;
        private final ListChangeListener<T> itemsContentObserver = c -> this.updateCurrentIndex();
        private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
        private ObjectProperty<ObservableList<T>> items;

        public ListSpinnerValueFactory(@NamedArg(value="items") ObservableList<T> items) {
            this.setItems(items);
            this.setConverter(new StringConverter<T>(){

                @Override
                public String toString(T value) {
                    if (value == null) {
                        return "";
                    }
                    return value.toString();
                }

                @Override
                public T fromString(String string) {
                    return string;
                }
            });
            this.valueProperty().addListener((o, oldValue, newValue) -> {
                int newIndex = -1;
                if (items.contains(newValue)) {
                    newIndex = items.indexOf(newValue);
                } else {
                    items.add(newValue);
                    newIndex = items.indexOf(newValue);
                }
                this.currentIndex = newIndex;
            });
            this.setValue(this._getValue(this.currentIndex));
        }

        public final void setItems(ObservableList<T> value) {
            this.itemsProperty().set(value);
        }

        public final ObservableList<T> getItems() {
            return this.items == null ? null : (ObservableList)this.items.get();
        }

        public final ObjectProperty<ObservableList<T>> itemsProperty() {
            if (this.items == null) {
                this.items = new SimpleObjectProperty<ObservableList<T>>(this, "items"){
                    WeakReference<ObservableList<T>> oldItemsRef;

                    @Override
                    protected void invalidated() {
                        ObservableList oldItems = this.oldItemsRef == null ? null : (ObservableList)this.oldItemsRef.get();
                        ObservableList newItems = this.getItems();
                        if (oldItems != null) {
                            oldItems.removeListener(weakItemsContentObserver);
                        }
                        if (newItems != null) {
                            newItems.addListener(weakItemsContentObserver);
                        }
                        this.updateCurrentIndex();
                        this.oldItemsRef = new WeakReference(this.getItems());
                    }
                };
            }
            return this.items;
        }

        @Override
        public void decrement(int steps) {
            int max = this.getItemsSize() - 1;
            int newIndex = this.currentIndex - steps;
            this.currentIndex = newIndex >= 0 ? newIndex : (this.isWrapAround() ? Spinner.wrapValue(newIndex, 0, max + 1) : 0);
            this.setValue(this._getValue(this.currentIndex));
        }

        @Override
        public void increment(int steps) {
            int newIndex = this.currentIndex + steps;
            int max = this.getItemsSize() - 1;
            this.currentIndex = newIndex <= max ? newIndex : (this.isWrapAround() ? Spinner.wrapValue(newIndex, 0, max + 1) : max);
            this.setValue(this._getValue(this.currentIndex));
        }

        private int getItemsSize() {
            ObservableList<T> items = this.getItems();
            return items == null ? 0 : items.size();
        }

        private void updateCurrentIndex() {
            int itemsSize = this.getItemsSize();
            if (this.currentIndex < 0 || this.currentIndex >= itemsSize) {
                this.currentIndex = 0;
            }
            this.setValue(this._getValue(this.currentIndex));
        }

        private T _getValue(int index) {
            ObservableList<T> items = this.getItems();
            return items == null ? null : (index >= 0 && index < items.size() ? items.get(index) : null);
        }
    }
}

