/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

class TreeUtil {
    TreeUtil() {
    }

    static <T> int getExpandedDescendantCount(TreeItem<T> node, boolean treeItemCountDirty) {
        if (node == null) {
            return 0;
        }
        if (node.isLeaf()) {
            return 1;
        }
        return node.getExpandedDescendentCount(treeItemCountDirty);
    }

    static int updateExpandedItemCount(TreeItem treeItem, boolean treeItemCountDirty, boolean isShowRoot) {
        if (treeItem == null) {
            return 0;
        }
        if (!treeItem.isExpanded()) {
            return 1;
        }
        int count = TreeUtil.getExpandedDescendantCount(treeItem, treeItemCountDirty);
        if (!isShowRoot) {
            --count;
        }
        return count;
    }

    static <T> TreeItem<T> getItem(TreeItem<T> parent, int itemIndex, boolean treeItemCountDirty) {
        if (parent == null) {
            return null;
        }
        if (itemIndex == 0) {
            return parent;
        }
        if (itemIndex >= TreeUtil.getExpandedDescendantCount(parent, treeItemCountDirty)) {
            return null;
        }
        ObservableList<TreeItem<T>> children = parent.getChildren();
        if (children == null) {
            return null;
        }
        int idx = itemIndex - 1;
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            TreeItem child = (TreeItem)children.get(i);
            if (idx == 0) {
                return child;
            }
            if (child.isLeaf() || !child.isExpanded()) {
                --idx;
                continue;
            }
            int expandedChildCount = TreeUtil.getExpandedDescendantCount(child, treeItemCountDirty);
            if (idx >= expandedChildCount) {
                idx -= expandedChildCount;
                continue;
            }
            TreeItem<T> result = TreeUtil.getItem(child, idx, treeItemCountDirty);
            if (result != null) {
                return result;
            }
            --idx;
        }
        return null;
    }

    static <T> int getRow(TreeItem<T> item, TreeItem<T> root, boolean treeItemCountDirty, boolean isShowRoot) {
        if (item == null) {
            return -1;
        }
        if (isShowRoot && item.equals(root)) {
            return 0;
        }
        int row = 0;
        TreeItem<T> i = item;
        TreeItem<T> p = item.getParent();
        boolean parentIsCollapsed = false;
        while (!i.equals(root) && p != null) {
            if (!p.isExpanded()) {
                parentIsCollapsed = true;
                break;
            }
            ObservableList siblings = p.children;
            int itemIndex = siblings.indexOf(i);
            for (int pos = itemIndex - 1; pos > -1; --pos) {
                TreeItem sibling = (TreeItem)siblings.get(pos);
                if (sibling == null) continue;
                row += TreeUtil.getExpandedDescendantCount(sibling, treeItemCountDirty);
                if (!sibling.equals(root)) continue;
                if (!isShowRoot) {
                    return -1;
                }
                return row;
            }
            i = p;
            p = p.getParent();
            ++row;
        }
        return p == null && row == 0 || parentIsCollapsed ? -1 : (isShowRoot ? row : row - 1);
    }
}

