/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;

public final class BorderWidths {
    public static final double AUTO = -1.0;
    public static final BorderWidths DEFAULT = new BorderWidths(1.0, 1.0, 1.0, 1.0, false, false, false, false);
    public static final BorderWidths EMPTY = new BorderWidths(0.0, 0.0, 0.0, 0.0, false, false, false, false);
    public static final BorderWidths FULL = new BorderWidths(1.0, 1.0, 1.0, 1.0, true, true, true, true);
    final double top;
    final double right;
    final double bottom;
    final double left;
    final boolean topAsPercentage;
    final boolean rightAsPercentage;
    final boolean bottomAsPercentage;
    final boolean leftAsPercentage;
    private final int hash;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public final boolean isTopAsPercentage() {
        return this.topAsPercentage;
    }

    public final boolean isRightAsPercentage() {
        return this.rightAsPercentage;
    }

    public final boolean isBottomAsPercentage() {
        return this.bottomAsPercentage;
    }

    public final boolean isLeftAsPercentage() {
        return this.leftAsPercentage;
    }

    public BorderWidths(@NamedArg(value="width") double width) {
        this(width, width, width, width, false, false, false, false);
    }

    public BorderWidths(@NamedArg(value="top") double top, @NamedArg(value="right") double right, @NamedArg(value="bottom") double bottom, @NamedArg(value="left") double left) {
        this(top, right, bottom, left, false, false, false, false);
    }

    public BorderWidths(@NamedArg(value="top") double top, @NamedArg(value="right") double right, @NamedArg(value="bottom") double bottom, @NamedArg(value="left") double left, @NamedArg(value="topAsPercentage") boolean topAsPercentage, @NamedArg(value="rightAsPercentage") boolean rightAsPercentage, @NamedArg(value="bottomAsPercentage") boolean bottomAsPercentage, @NamedArg(value="leftAsPercentage") boolean leftAsPercentage) {
        if (top != -1.0 && top < 0.0 || right != -1.0 && right < 0.0 || bottom != -1.0 && bottom < 0.0 || left != -1.0 && left < 0.0) {
            throw new IllegalArgumentException("None of the widths can be < 0");
        }
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.topAsPercentage = topAsPercentage;
        this.rightAsPercentage = rightAsPercentage;
        this.bottomAsPercentage = bottomAsPercentage;
        this.leftAsPercentage = leftAsPercentage;
        long temp = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.topAsPercentage ? 1 : 0);
        result = 31 * result + (this.rightAsPercentage ? 1 : 0);
        result = 31 * result + (this.bottomAsPercentage ? 1 : 0);
        this.hash = result = 31 * result + (this.leftAsPercentage ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderWidths that = (BorderWidths)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (Double.compare(that.bottom, this.bottom) != 0) {
            return false;
        }
        if (this.bottomAsPercentage != that.bottomAsPercentage) {
            return false;
        }
        if (Double.compare(that.left, this.left) != 0) {
            return false;
        }
        if (this.leftAsPercentage != that.leftAsPercentage) {
            return false;
        }
        if (Double.compare(that.right, this.right) != 0) {
            return false;
        }
        if (this.rightAsPercentage != that.rightAsPercentage) {
            return false;
        }
        if (Double.compare(that.top, this.top) != 0) {
            return false;
        }
        return this.topAsPercentage == that.topAsPercentage;
    }

    public int hashCode() {
        return this.hash;
    }
}

