/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.directwrite;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.directwrite.DWDisposer;
import com.sun.javafx.font.directwrite.DWFactory;
import com.sun.javafx.font.directwrite.DWFontStrike;
import com.sun.javafx.font.directwrite.DWRITE_GLYPH_METRICS;
import com.sun.javafx.font.directwrite.IDWriteFactory;
import com.sun.javafx.font.directwrite.IDWriteFont;
import com.sun.javafx.font.directwrite.IDWriteFontCollection;
import com.sun.javafx.font.directwrite.IDWriteFontFace;
import com.sun.javafx.font.directwrite.IDWriteFontFamily;
import com.sun.javafx.font.directwrite.IDWriteFontFile;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;

class DWFontFile
extends PrismFontFile {
    private IDWriteFontFace fontFace = this.createFontFace();
    private DWDisposer disposer;

    DWFontFile(String name, String filename, int fIndex, boolean register, boolean embedded, boolean copy, boolean tracked) throws Exception {
        super(name, filename, fIndex, register, embedded, copy, tracked);
        if (PrismFontFactory.debugFonts && this.fontFace == null) {
            System.err.println("Failed to create IDWriteFontFace for " + this);
        }
        if (copy) {
            this.disposer = new DWDisposer(this.fontFace);
            Disposer.addRecord(this, this.disposer);
        }
    }

    private IDWriteFontFace createEmbeddedFontFace() {
        IDWriteFactory factory = DWFactory.getDWriteFactory();
        IDWriteFontFile fontFile = factory.CreateFontFileReference(this.getFileName());
        if (fontFile == null) {
            return null;
        }
        boolean[] isSupportedFontType = new boolean[1];
        int[] fontFileType = new int[1];
        int[] fontFaceType = new int[1];
        int[] numberOfFaces = new int[1];
        int hr = fontFile.Analyze(isSupportedFontType, fontFileType, fontFaceType, numberOfFaces);
        IDWriteFontFace face = null;
        if (hr == 0 && isSupportedFontType[0]) {
            int faceIndex = this.getFontIndex();
            int simulation = 0;
            face = factory.CreateFontFace(fontFaceType[0], fontFile, faceIndex, simulation);
        }
        fontFile.Release();
        return face;
    }

    private IDWriteFontFace createFontFace() {
        if (this.isEmbeddedFont()) {
            return this.createEmbeddedFontFace();
        }
        IDWriteFontCollection collection = DWFactory.getFontCollection();
        int index = collection.FindFamilyName(this.getFamilyName());
        if (index == -1) {
            return this.createEmbeddedFontFace();
        }
        IDWriteFontFamily family = collection.GetFontFamily(index);
        if (family == null) {
            return null;
        }
        int weight = this.isBold() ? 700 : 400;
        int stretch = 5;
        int style = this.isItalic() ? 2 : 0;
        IDWriteFont font = family.GetFirstMatchingFont(weight, stretch, style);
        family.Release();
        if (font == null) {
            return null;
        }
        IDWriteFontFace face = font.CreateFontFace();
        font.Release();
        return face;
    }

    IDWriteFontFace getFontFace() {
        return this.fontFace;
    }

    Path2D getGlyphOutline(int gc, float size) {
        if (this.fontFace == null) {
            return null;
        }
        if (size == 0.0f) {
            return new Path2D();
        }
        return this.fontFace.GetGlyphRunOutline(size, (short)gc, false);
    }

    RectBounds getBBox(int glyphCode, float size) {
        float[] bb = new float[4];
        this.getGlyphBoundingBox(glyphCode, size, bb);
        return new RectBounds(bb[0], bb[1], bb[2], bb[3]);
    }

    @Override
    protected int[] createGlyphBoundingBox(int gc) {
        if (this.fontFace == null) {
            return null;
        }
        DWRITE_GLYPH_METRICS metrics = this.fontFace.GetDesignGlyphMetrics((short)gc, false);
        if (metrics == null) {
            return null;
        }
        int[] bb = new int[]{metrics.leftSideBearing, metrics.verticalOriginY - metrics.advanceHeight + metrics.bottomSideBearing, metrics.advanceWidth - metrics.rightSideBearing, metrics.verticalOriginY - metrics.topSideBearing};
        return bb;
    }

    @Override
    protected PrismFontStrike<DWFontFile> createStrike(float size, BaseTransform transform, int aaMode, FontStrikeDesc desc) {
        return new DWFontStrike(this, size, transform, aaMode, desc);
    }

    @Override
    protected synchronized void disposeOnShutdown() {
        if (this.fontFace != null) {
            if (this.disposer != null) {
                this.disposer.dispose();
            } else {
                this.fontFace.Release();
                if (PrismFontFactory.debugFonts) {
                    System.err.println("null disposer for " + this.fontFace);
                }
            }
            if (PrismFontFactory.debugFonts) {
                System.err.println("fontFace freed: " + this.fontFace);
            }
            this.fontFace = null;
        }
        super.disposeOnShutdown();
    }
}

