/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

class SimpleClipInterpolator
extends ClipInterpolator {
    private static final KeyFrame ZERO_FRAME = new KeyFrame(Duration.ZERO, new KeyValue[0]);
    private KeyFrame startKeyFrame;
    private KeyFrame endKeyFrame;
    private long endTicks;
    private InterpolationInterval[] interval;
    private int undefinedStartValueCount;
    private long ticks;
    private boolean invalid = true;

    SimpleClipInterpolator(KeyFrame startKeyFrame, KeyFrame endKeyFrame, long ticks) {
        this.startKeyFrame = startKeyFrame;
        this.endKeyFrame = endKeyFrame;
        this.endTicks = ticks;
    }

    SimpleClipInterpolator(KeyFrame endKeyFrame, long ticks) {
        this.startKeyFrame = ZERO_FRAME;
        this.endKeyFrame = endKeyFrame;
        this.endTicks = ticks;
    }

    @Override
    ClipInterpolator setKeyFrames(KeyFrame[] keyFrames, long[] keyFrameTicks) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrames) != 2) {
            return ClipInterpolator.create(keyFrames, keyFrameTicks);
        }
        if (keyFrames.length == 1) {
            this.startKeyFrame = ZERO_FRAME;
            this.endKeyFrame = keyFrames[0];
            this.endTicks = keyFrameTicks[0];
        } else {
            this.startKeyFrame = keyFrames[0];
            this.endKeyFrame = keyFrames[1];
            this.endTicks = keyFrameTicks[1];
        }
        this.invalid = true;
        return this;
    }

    @Override
    void validate(boolean forceSync) {
        if (this.invalid) {
            this.ticks = this.endTicks;
            HashMap map = new HashMap();
            for (KeyValue keyValue : this.endKeyFrame.getValues()) {
                map.put(keyValue.getTarget(), keyValue);
            }
            int valueCount = map.size();
            this.interval = new InterpolationInterval[valueCount];
            int i = 0;
            for (KeyValue startKeyValue : this.startKeyFrame.getValues()) {
                WritableValue<?> target = startKeyValue.getTarget();
                KeyValue endKeyValue = (KeyValue)map.get(target);
                if (endKeyValue == null) continue;
                this.interval[i++] = InterpolationInterval.create(endKeyValue, this.ticks, startKeyValue, this.ticks);
                map.remove(target);
            }
            this.undefinedStartValueCount = map.values().size();
            for (KeyValue endKeyValue : map.values()) {
                this.interval[i++] = InterpolationInterval.create(endKeyValue, this.ticks);
            }
            this.invalid = false;
        } else if (forceSync) {
            int n = this.interval.length;
            for (int i = n - this.undefinedStartValueCount; i < n; ++i) {
                this.interval[i].recalculateStartValue();
            }
        }
    }

    @Override
    void interpolate(long ticks) {
        double frac = (double)ticks / (double)this.ticks;
        int n = this.interval.length;
        for (int i = 0; i < n; ++i) {
            this.interval[i].interpolate(frac);
        }
    }
}

