/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.mac.MacAccessible;
import com.sun.glass.ui.mac.MacCommonDialogs;
import com.sun.glass.ui.mac.MacCursor;
import com.sun.glass.ui.mac.MacPixels;
import com.sun.glass.ui.mac.MacRobot;
import com.sun.glass.ui.mac.MacTimer;
import com.sun.glass.ui.mac.MacView;
import com.sun.glass.ui.mac.MacWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;

final class MacApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private boolean isTaskbarApplication = false;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private Menu appleMenu;
    static final long BROWSER_PARENT_ID = -1L;

    private static native void _initIDs(boolean var0);

    static native int _getMacKey(int var0);

    MacApplication() {
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!isEventThread) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    native void _runLoop(ClassLoader var1, Runnable var2, boolean var3);

    @Override
    protected void runLoop(Runnable launchable) {
        this.isTaskbarApplication = AccessController.doPrivileged(() -> {
            String taskbarAppProp = System.getProperty("glass.taskbarApplication");
            return !"false".equalsIgnoreCase(taskbarAppProp);
        });
        ClassLoader classLoader = MacApplication.class.getClassLoader();
        this._runLoop(classLoader, launchable, this.isTaskbarApplication);
    }

    private native void _finishTerminating();

    @Override
    protected void finishTerminating() {
        this._finishTerminating();
        super.finishTerminating();
    }

    private void notifyApplicationDidTerminate() {
        MacApplication.setEventThread(null);
    }

    private void setEventThread() {
        MacApplication.setEventThread(Thread.currentThread());
    }

    private native Object _enterNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    private native void _leaveNestedEventLoopImpl(Object var1);

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this._leaveNestedEventLoopImpl(retValue);
    }

    private native void _hide();

    private native void _hideOtherApplications();

    private native void _unhideAllApplications();

    public void installAppleMenu(MenuBar menubar) {
        this.appleMenu = this.createMenu("Apple");
        MenuItem hideMenu = this.createMenuItem("Hide " + this.getName(), new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._hide();
            }

            @Override
            public void validate() {
            }
        }, 104, 16);
        this.appleMenu.add(hideMenu);
        MenuItem hideOthersMenu = this.createMenuItem("Hide Others", new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._hideOtherApplications();
            }

            @Override
            public void validate() {
            }
        }, 104, 24);
        this.appleMenu.add(hideOthersMenu);
        MenuItem unhideAllMenu = this.createMenuItem("Show All", new MenuItem.Callback(){

            @Override
            public void action() {
                MacApplication.this._unhideAllApplications();
            }

            @Override
            public void validate() {
            }
        });
        this.appleMenu.add(unhideAllMenu);
        this.appleMenu.add(MenuItem.Separator);
        MenuItem quitMenu = this.createMenuItem("Quit " + this.getName(), new MenuItem.Callback(){

            @Override
            public void action() {
                Application.EventHandler eh = MacApplication.this.getEventHandler();
                if (eh != null) {
                    eh.handleQuitAction(Application.GetApplication(), System.nanoTime());
                }
            }

            @Override
            public void validate() {
            }
        }, 113, 16);
        this.appleMenu.add(quitMenu);
        menubar.add(this.appleMenu);
    }

    public Menu getAppleMenu() {
        return this.appleMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menubar) {
        this.installAppleMenu(menubar);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new MacWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        MacWindow window = new MacWindow(parent);
        if (parent == -1L) {
            window.setView(this.createView());
        }
        return window;
    }

    @Override
    public View createView() {
        return new MacView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new MacCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new MacCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        MacCursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return MacCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new MacPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return MacPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new MacRobot();
    }

    @Override
    protected native double staticScreen_getVideoRefreshPeriod();

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MacTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MacTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MacTimer.getMaxPeriod_impl();
    }

    @Override
    public Accessible createAccessible() {
        return new MacAccessible();
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        return MacCommonDialogs.showFileChooser_impl(owner, folder, filename, title, type, multipleMode, extensionFilters, defaultFilterIndex);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return MacCommonDialogs.showFolderChooser_impl(owner, folder, title);
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MacView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MacView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MacView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return true;
    }

    @Override
    protected native boolean _supportsSystemMenu();

    protected native String _getRemoteLayerServerName();

    public String getRemoteLayerServerName() {
        return this._getRemoteLayerServerName();
    }

    private native String _getDataDirectory();

    @Override
    public String getDataDirectory() {
        MacApplication.checkEventThread();
        String baseDirectory = this._getDataDirectory();
        if (baseDirectory == null || baseDirectory.length() == 0) {
            return super.getDataDirectory();
        }
        return baseDirectory + File.separator + this.name + File.separator;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    static {
        AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        boolean disableSyncRendering = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.disableSyncRendering"));
        MacApplication._initIDs(disableSyncRendering);
    }
}

