/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import com.sun.javafx.event.CompositeEventTarget;
import com.sun.javafx.event.EventDispatchTree;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.event.EventDispatchChain;
import javafx.event.EventTarget;

public class CompositeEventTargetImpl
implements CompositeEventTarget {
    private final Set<EventTarget> eventTargets;

    public CompositeEventTargetImpl(EventTarget ... eventTargets) {
        HashSet<EventTarget> mutableSet = new HashSet<EventTarget>(eventTargets.length);
        mutableSet.addAll(Arrays.asList(eventTargets));
        this.eventTargets = Collections.unmodifiableSet(mutableSet);
    }

    @Override
    public Set<EventTarget> getTargets() {
        return this.eventTargets;
    }

    @Override
    public boolean containsTarget(EventTarget target) {
        return this.eventTargets.contains(target);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        EventDispatchTree eventDispatchTree = (EventDispatchTree)tail;
        for (EventTarget eventTarget : this.eventTargets) {
            EventDispatchTree targetDispatchTree = eventDispatchTree.createTree();
            eventDispatchTree = eventDispatchTree.mergeTree((EventDispatchTree)eventTarget.buildEventDispatchChain(targetDispatchTree));
        }
        return eventDispatchTree;
    }
}

