/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.AreaIterator;
import com.sun.javafx.geom.AreaOp;
import com.sun.javafx.geom.Crossings;
import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Enumeration;
import java.util.Vector;

public class Area
extends Shape {
    private static final Vector EmptyCurves = new Vector();
    private Vector curves;
    private RectBounds cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(Shape s) {
        this.curves = s instanceof Area ? ((Area)s).curves : Area.pathToCurves(s.getPathIterator(null));
    }

    public Area(PathIterator iter) {
        this.curves = Area.pathToCurves(iter);
    }

    private static Vector pathToCurves(PathIterator pi) {
        Vector curves = new Vector();
        int windingRule = pi.getWindingRule();
        float[] coords = new float[6];
        double[] tmp = new double[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx = (double)coords[0];
                    cury = movy = (double)coords[1];
                    Curve.insertMove(curves, movx, movy);
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    Curve.insertLine(curves, curx, cury, newx, newy);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    double newx = coords[2];
                    double newy = coords[3];
                    Curve.insertQuad(curves, tmp, curx, cury, coords[0], coords[1], coords[2], coords[3]);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    double newx = coords[4];
                    double newy = coords[5];
                    Curve.insertCubic(curves, tmp, curx, cury, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        Curve.insertLine(curves, curx, cury, movx, movy);
        AreaOp operator = windingRule == 0 ? new AreaOp.EOWindOp() : new AreaOp.NZWindOp();
        return operator.calculate(curves, EmptyCurves);
    }

    public void add(Area rhs) {
        this.curves = new AreaOp.AddOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void subtract(Area rhs) {
        this.curves = new AreaOp.SubOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void intersect(Area rhs) {
        this.curves = new AreaOp.IntOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area rhs) {
        this.curves = new AreaOp.XorOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    public boolean isPolygonal() {
        Enumeration enum_ = this.curves.elements();
        while (enum_.hasMoreElements()) {
            if (((Curve)enum_.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int size = this.curves.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        Curve c1 = (Curve)this.curves.get(1);
        Curve c2 = (Curve)this.curves.get(2);
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        if (c1.getXTop() != c1.getXBot() || c2.getXTop() != c2.getXBot()) {
            return false;
        }
        return c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enum_ = this.curves.elements();
        enum_.nextElement();
        while (enum_.hasMoreElements()) {
            if (((Curve)enum_.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    private RectBounds getCachedBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        RectBounds r = new RectBounds();
        if (this.curves.size() > 0) {
            Curve c = (Curve)this.curves.get(0);
            r.setBounds((float)c.getX0(), (float)c.getY0(), 0.0f, 0.0f);
            for (int i = 1; i < this.curves.size(); ++i) {
                ((Curve)this.curves.get(i)).enlarge(r);
            }
        }
        this.cachedBounds = r;
        return this.cachedBounds;
    }

    @Override
    public RectBounds getBounds() {
        return new RectBounds(this.getCachedBounds());
    }

    public boolean isEquivalent(Area other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Vector c = new AreaOp.XorOp().calculate(this.curves, other.curves);
        return c.isEmpty();
    }

    public void transform(BaseTransform tx) {
        if (tx == null) {
            throw new NullPointerException("transform must not be null");
        }
        this.curves = Area.pathToCurves(this.getPathIterator(tx));
        this.invalidateBounds();
    }

    public Area createTransformedArea(BaseTransform tx) {
        Area a = new Area(this);
        a.transform(tx);
        return a;
    }

    @Override
    public boolean contains(float x, float y) {
        if (!this.getCachedBounds().contains(x, y)) {
            return false;
        }
        Enumeration enum_ = this.curves.elements();
        int crossings = 0;
        while (enum_.hasMoreElements()) {
            Curve c = (Curve)enum_.nextElement();
            crossings += c.crossingsFor(x, y);
        }
        return crossings & true;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        if (w < 0.0f || h < 0.0f) {
            return false;
        }
        if (!this.getCachedBounds().contains(x, y) || !this.getCachedBounds().contains(x + w, y + h)) {
            return false;
        }
        Crossings c = Crossings.findCrossings(this.curves, x, y, x + w, y + h);
        return c != null && c.covers(y, y + h);
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        if (w < 0.0f || h < 0.0f) {
            return false;
        }
        if (!this.getCachedBounds().intersects(x, y, w, h)) {
            return false;
        }
        Crossings c = Crossings.findCrossings(this.curves, x, y, x + w, y + h);
        return c == null || !c.isEmpty();
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new AreaIterator(this.curves, tx);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new FlatteningPathIterator(this.getPathIterator(tx), flatness);
    }

    @Override
    public Area copy() {
        return new Area(this);
    }
}

