/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.ShapePair;
import com.sun.javafx.geom.transform.BaseTransform;

public class GeneralShapePair
extends ShapePair {
    private final Shape outer;
    private final Shape inner;
    private final int combinationType;

    public GeneralShapePair(Shape outer, Shape inner, int combinationType) {
        this.outer = outer;
        this.inner = inner;
        this.combinationType = combinationType;
    }

    @Override
    public final int getCombinationType() {
        return this.combinationType;
    }

    @Override
    public final Shape getOuterShape() {
        return this.outer;
    }

    @Override
    public final Shape getInnerShape() {
        return this.inner;
    }

    @Override
    public Shape copy() {
        return new GeneralShapePair(this.outer.copy(), this.inner.copy(), this.combinationType);
    }

    @Override
    public boolean contains(float x, float y) {
        if (this.combinationType == 4) {
            return this.outer.contains(x, y) && this.inner.contains(x, y);
        }
        return this.outer.contains(x, y) && !this.inner.contains(x, y);
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        if (this.combinationType == 4) {
            return this.outer.intersects(x, y, w, h) && this.inner.intersects(x, y, w, h);
        }
        return this.outer.intersects(x, y, w, h) && !this.inner.contains(x, y, w, h);
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        if (this.combinationType == 4) {
            return this.outer.contains(x, y, w, h) && this.inner.contains(x, y, w, h);
        }
        return this.outer.contains(x, y, w, h) && !this.inner.intersects(x, y, w, h);
    }

    @Override
    public RectBounds getBounds() {
        RectBounds b = this.outer.getBounds();
        if (this.combinationType == 4) {
            b.intersectWith(this.inner.getBounds());
        }
        return b;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new FlatteningPathIterator(this.getPathIterator(tx), flatness);
    }
}

