/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.DeployParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.types.resources.FileResource;

public final class Utils {
    private Utils() {
    }

    public static void addResources(CommonParams commonParams, org.apache.tools.ant.types.FileSet fileset) {
        for (FileResource fr : fileset) {
            commonParams.addResource(fr.getBaseDir(), fr.getFile());
        }
    }

    public static void addResources(DeployParams deployParams, org.apache.tools.ant.types.FileSet fileset, String type) {
        for (FileResource fr : fileset) {
            deployParams.addResource(fr.getBaseDir(), fr.getFile(), type);
        }
    }

    public static void addResources(DeployParams deployParams, FileSet fileset) {
        Iterator i = fileset.iterator();
        while (i.hasNext()) {
            FileResource fr = (FileResource)i.next();
            deployParams.addResource(fr.getBaseDir(), fr.getFile(), fileset.getMode(), fileset.getTypeAsString(), fileset.getOs(), fileset.getArch());
        }
    }

    public static void readFully(InputStream is) throws IOException {
        byte[] buf = new byte[10000];
        while (is.read(buf) != -1) {
        }
    }

    public static void readAllFully(JarFile jf) throws IOException {
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            Utils.readFully(jf.getInputStream(je));
        }
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    public static String getBase64Encoded(CertPath certPath) throws CertificateEncodingException {
        return Base64.getEncoder().encodeToString(certPath.getEncoded());
    }
}

