/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

class PixelUtils {
    private static ImageFormatDescription[] supportedFormats = ImageStorage.getSupportedDescriptions();

    private PixelUtils() {
    }

    protected static boolean supportedFormatType(String type) {
        for (ImageFormatDescription ifd : supportedFormats) {
            for (String ext : ifd.getExtensions()) {
                if (!type.endsWith(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static Pixels imageToPixels(Image image) {
        Application app;
        PixelFormat.DataType pixelType;
        block7: {
            ByteBuffer bytes;
            block9: {
                block8: {
                    pixelType = image.getDataType();
                    app = Application.GetApplication();
                    int nativeFormat = Pixels.getNativeFormat();
                    if (pixelType != PixelFormat.DataType.BYTE) break block7;
                    bytes = (ByteBuffer)image.getPixelBuffer();
                    int w = image.getWidth();
                    int h = image.getHeight();
                    int scanBytes = image.getScanlineStride();
                    if (image.getBytesPerPixelUnit() != 3) break block8;
                    switch (nativeFormat) {
                        case 2: {
                            byte[] newbytes = new byte[w * h * 4];
                            ByteRgb.ToByteArgbConverter().convert(bytes, 0, scanBytes, newbytes, 0, w * 4, w, h);
                            bytes = ByteBuffer.wrap(newbytes);
                            break block9;
                        }
                        case 1: {
                            byte[] newbytes = new byte[w * h * 4];
                            ByteRgb.ToByteBgraPreConverter().convert(bytes, 0, scanBytes, newbytes, 0, w * 4, w, h);
                            bytes = ByteBuffer.wrap(newbytes);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("unhandled native format: " + nativeFormat);
                        }
                    }
                }
                if (image.getPixelFormat() != PixelFormat.BYTE_BGRA_PRE) {
                    throw new IllegalArgumentException("non-RGB image format");
                }
            }
            Pixels pixels = app.createPixels(image.getWidth(), image.getHeight(), bytes);
            return pixels;
        }
        if (pixelType == PixelFormat.DataType.INT) {
            if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                String MSG = "INT_ARGB_PRE only supported for LITTLE_ENDIAN machines";
                throw new UnsupportedOperationException("INT_ARGB_PRE only supported for LITTLE_ENDIAN machines");
            }
            IntBuffer ints = (IntBuffer)image.getPixelBuffer();
            Pixels pixels = app.createPixels(image.getWidth(), image.getHeight(), ints);
            return pixels;
        }
        throw new IllegalArgumentException("unhandled image type: " + (Object)((Object)pixelType));
    }

    public static Image pixelsToImage(Pixels pix) {
        Buffer pixbuf = pix.getPixels();
        if (pix.getBytesPerComponent() == 1) {
            ByteBuffer buf = ByteBuffer.allocateDirect(pixbuf.capacity());
            buf.put((ByteBuffer)pixbuf);
            buf.rewind();
            return Image.fromByteBgraPreData(buf, pix.getWidth(), pix.getHeight());
        }
        if (pix.getBytesPerComponent() == 4) {
            IntBuffer buf = IntBuffer.allocate(pixbuf.capacity());
            buf.put((IntBuffer)pixbuf);
            buf.rewind();
            return Image.fromIntArgbPreData((IntBuffer)pixbuf, pix.getWidth(), pix.getHeight());
        }
        throw new IllegalArgumentException("unhandled pixel buffer: " + pixbuf.getClass().getName());
    }
}

