/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.webkit.graphics.WCImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Base64;
import java.util.Iterator;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritablePixelFormat;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

abstract class PrismImage
extends WCImage {
    PrismImage() {
    }

    abstract Image getImage();

    abstract Graphics getGraphics();

    abstract void draw(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    abstract void dispose();

    @Override
    public Object getPlatformImage() {
        return this.getImage();
    }

    @Override
    public void deref() {
        super.deref();
        if (!this.hasRefs()) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final byte[] toData(String mimeType) {
        BufferedImage image = this.toBufferedImage(mimeType.equals("image/jpeg"));
        if (image != null) {
            Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(mimeType);
            while (it.hasNext()) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                ImageWriter writer = it.next();
                try {
                    writer.setOutput(ImageIO.createImageOutputStream(output));
                    writer.write(image);
                }
                catch (IOException exception) {}
                continue;
                finally {
                    writer.dispose();
                    continue;
                }
                return output.toByteArray();
            }
        }
        return null;
    }

    @Override
    protected final String toDataURL(String mimeType) {
        byte[] data = this.toData(mimeType);
        if (data != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("data:").append(mimeType).append(";base64,");
            sb.append(Base64.getMimeEncoder().encodeToString(data));
            return sb.toString();
        }
        return null;
    }

    private static int getBestBufferedImageType(PixelFormat<?> fxFormat) {
        switch (fxFormat.getType()) {
            default: {
                return 3;
            }
            case BYTE_BGRA: 
            case INT_ARGB: {
                return 2;
            }
            case BYTE_RGB: {
                return 1;
            }
            case BYTE_INDEXED: 
        }
        return fxFormat.isPremultiplied() ? 3 : 2;
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bimg) {
        switch (bimg.getType()) {
            case 1: 
            case 3: {
                return PixelFormat.getIntArgbPreInstance();
            }
            case 2: {
                return PixelFormat.getIntArgbInstance();
            }
        }
        throw new InternalError("Failed to validate BufferedImage type");
    }

    private static BufferedImage fromFXImage(Image img, boolean forceRGB) {
        int iw = img.getWidth();
        int ih = img.getHeight();
        int destImageType = forceRGB ? 1 : PrismImage.getBestBufferedImageType(img.getPlatformPixelFormat());
        BufferedImage bimg = new BufferedImage(iw, ih, destImageType);
        DataBufferInt db = (DataBufferInt)bimg.getRaster().getDataBuffer();
        int[] data = db.getData();
        int offset = bimg.getRaster().getDataBuffer().getOffset();
        int scan = 0;
        SampleModel sm = bimg.getRaster().getSampleModel();
        if (sm instanceof SinglePixelPackedSampleModel) {
            scan = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        }
        WritablePixelFormat<IntBuffer> pf = PrismImage.getAssociatedPixelFormat(bimg);
        img.getPixels(0, 0, iw, ih, pf, data, offset, scan);
        return bimg;
    }

    private BufferedImage toBufferedImage(boolean forceRGB) {
        try {
            return PrismImage.fromFXImage(this.getImage(), forceRGB);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public BufferedImage toBufferedImage() {
        return this.toBufferedImage(false);
    }
}

