/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.ps.Shader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Map;

final class D3DShader
extends D3DResource
implements Shader {
    private static IntBuffer itmp;
    private static FloatBuffer ftmp;
    private final Map<String, Integer> registers;
    private boolean valid;

    D3DShader(D3DContext context, long pData, Map<String, Integer> registers) {
        super(new D3DResource.D3DRecord(context, pData));
        this.valid = pData != 0L;
        this.registers = registers;
    }

    static native long init(long var0, ByteBuffer var2, int var3, boolean var4, boolean var5);

    private static native int enable(long var0, long var2);

    private static native int disable(long var0, long var2);

    private static native int setConstantsF(long var0, long var2, int var4, FloatBuffer var5, int var6, int var7);

    private static native int setConstantsI(long var0, long var2, int var4, IntBuffer var5, int var6, int var7);

    private static native int nGetRegister(long var0, long var2, String var4);

    @Override
    public void enable() {
        int res = D3DShader.enable(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource());
        this.valid &= res >= 0;
        this.d3dResRecord.getContext();
        D3DContext.validate(res);
    }

    @Override
    public void disable() {
        int res = D3DShader.disable(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource());
        this.valid &= res >= 0;
        this.d3dResRecord.getContext();
        D3DContext.validate(res);
    }

    private static void checkTmpIntBuf() {
        if (itmp == null) {
            itmp = BufferUtil.newIntBuffer(4);
        }
        itmp.clear();
    }

    @Override
    public void setConstant(String name, int i0) {
        this.setConstant(name, (float)i0);
    }

    @Override
    public void setConstant(String name, int i0, int i1) {
        this.setConstant(name, (float)i0, (float)i1);
    }

    @Override
    public void setConstant(String name, int i0, int i1, int i2) {
        this.setConstant(name, (float)i0, (float)i1, (float)i2);
    }

    @Override
    public void setConstant(String name, int i0, int i1, int i2, int i3) {
        this.setConstant(name, (float)i0, (float)i1, (float)i2, (float)i3);
    }

    @Override
    public void setConstants(String name, IntBuffer buf, int off, int count) {
        throw new InternalError("Not yet implemented");
    }

    private static void checkTmpFloatBuf() {
        if (ftmp == null) {
            ftmp = BufferUtil.newFloatBuffer(4);
        }
        ftmp.clear();
    }

    @Override
    public void setConstant(String name, float f0) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f0);
        this.setConstants(name, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String name, float f0, float f1) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f0);
        ftmp.put(f1);
        this.setConstants(name, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String name, float f0, float f1, float f2) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f0);
        ftmp.put(f1);
        ftmp.put(f2);
        this.setConstants(name, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String name, float f0, float f1, float f2, float f3) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f0);
        ftmp.put(f1);
        ftmp.put(f2);
        ftmp.put(f3);
        this.setConstants(name, ftmp, 0, 1);
    }

    @Override
    public void setConstants(String name, FloatBuffer buf, int off, int count) {
        int res = D3DShader.setConstantsF(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), this.getRegister(name), buf, off, count);
        this.valid &= res >= 0;
        this.d3dResRecord.getContext();
        D3DContext.validate(res);
    }

    private int getRegister(String name) {
        Integer reg = this.registers.get(name);
        if (reg == null) {
            int nRegister = D3DShader.nGetRegister(this.d3dResRecord.getContext().getContextHandle(), this.d3dResRecord.getResource(), name);
            if (nRegister < 0) {
                throw new IllegalArgumentException("Register not found for: " + name);
            }
            this.registers.put(name, nRegister);
            return nRegister;
        }
        return reg;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.valid = false;
    }
}

