/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.IntPixelAccessor;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseIntToByteConverter;
import com.sun.javafx.image.impl.BaseIntToIntConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.IntArgbPre;
import com.sun.javafx.image.impl.IntTo4ByteSameConverter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class IntArgb {
    public static final IntPixelGetter getter = Accessor.instance;
    public static final IntPixelSetter setter = Accessor.instance;
    public static final IntPixelAccessor accessor = Accessor.instance;
    private static IntToBytePixelConverter ToByteBgraObj;
    private static IntToIntPixelConverter ToIntArgbObj;

    public static IntToBytePixelConverter ToByteBgraConverter() {
        if (ToByteBgraObj == null) {
            ToByteBgraObj = new IntTo4ByteSameConverter(getter, ByteBgra.setter);
        }
        return ToByteBgraObj;
    }

    public static IntToBytePixelConverter ToByteBgraPreConverter() {
        return ToByteBgraPreConv.instance;
    }

    public static IntToIntPixelConverter ToIntArgbConverter() {
        if (ToIntArgbObj == null) {
            ToIntArgbObj = BaseIntToIntConverter.create(accessor);
        }
        return ToIntArgbObj;
    }

    public static IntToIntPixelConverter ToIntArgbPreConverter() {
        return ToIntArgbPreConv.instance;
    }

    static class ToByteBgraPreConv
    extends BaseIntToByteConverter {
        public static final IntToBytePixelConverter instance = new ToByteBgraPreConv();

        private ToByteBgraPreConv() {
            super(getter, ByteBgraPre.setter);
        }

        @Override
        void doConvert(int[] srcarr, int srcoff, int srcscanints, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanints -= w;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int pixel = srcarr[srcoff++];
                    int a = pixel >>> 24;
                    int r = pixel >> 16;
                    int g = pixel >> 8;
                    int b = pixel;
                    if (a < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = ((b & 0xFF) * a + 127) / 255;
                            g = ((g & 0xFF) * a + 127) / 255;
                            r = ((r & 0xFF) * a + 127) / 255;
                        }
                    }
                    dstarr[dstoff++] = (byte)b;
                    dstarr[dstoff++] = (byte)g;
                    dstarr[dstoff++] = (byte)r;
                    dstarr[dstoff++] = (byte)a;
                }
                srcoff += srcscanints;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(IntBuffer srcbuf, int srcoff, int srcscanints, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int pixel = srcbuf.get(srcoff + x);
                    int a = pixel >>> 24;
                    int r = pixel >> 16;
                    int g = pixel >> 8;
                    int b = pixel;
                    if (a < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = ((b & 0xFF) * a + 127) / 255;
                            g = ((g & 0xFF) * a + 127) / 255;
                            r = ((r & 0xFF) * a + 127) / 255;
                        }
                    }
                    dstbuf.put(dstoff, (byte)b);
                    dstbuf.put(dstoff + 1, (byte)g);
                    dstbuf.put(dstoff + 2, (byte)r);
                    dstbuf.put(dstoff + 3, (byte)a);
                    dstoff += 4;
                }
                srcoff += srcscanints;
                dstoff += dstscanbytes;
            }
        }
    }

    public static class ToIntArgbPreConv
    extends BaseIntToIntConverter {
        public static final IntToIntPixelConverter instance = new ToIntArgbPreConv();

        private ToIntArgbPreConv() {
            super(getter, IntArgbPre.setter);
        }

        @Override
        void doConvert(int[] srcarr, int srcoff, int srcscanints, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
            srcscanints -= w;
            dstscanints -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int pixel;
                    int a;
                    if ((a = (pixel = srcarr[srcoff++]) >>> 24) < 255) {
                        if (a == 0) {
                            pixel = 0;
                        } else {
                            int r = ((pixel >> 16 & 0xFF) * a + 127) / 255;
                            int g = ((pixel >> 8 & 0xFF) * a + 127) / 255;
                            int b = ((pixel & 0xFF) * a + 127) / 255;
                            pixel = a << 24 | r << 16 | g << 8 | b;
                        }
                    }
                    dstarr[dstoff++] = pixel;
                }
                srcoff += srcscanints;
                dstoff += dstscanints;
            }
        }

        @Override
        void doConvert(IntBuffer srcbuf, int srcoff, int srcscanints, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int pixel = srcbuf.get(srcoff + x);
                    int a = pixel >>> 24;
                    if (a < 255) {
                        if (a == 0) {
                            pixel = 0;
                        } else {
                            int r = ((pixel >> 16 & 0xFF) * a + 127) / 255;
                            int g = ((pixel >> 8 & 0xFF) * a + 127) / 255;
                            int b = ((pixel & 0xFF) * a + 127) / 255;
                            pixel = a << 24 | r << 16 | g << 8 | b;
                        }
                    }
                    dstbuf.put(dstoff + x, pixel);
                }
                srcoff += srcscanints;
                dstoff += dstscanints;
            }
        }
    }

    static class Accessor
    implements IntPixelAccessor {
        static final IntPixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 1;
        }

        @Override
        public int getArgb(int[] arr, int offset) {
            return arr[offset];
        }

        @Override
        public int getArgbPre(int[] arr, int offset) {
            return PixelUtils.NonPretoPre(arr[offset]);
        }

        @Override
        public int getArgb(IntBuffer buffer, int offset) {
            return buffer.get(offset);
        }

        @Override
        public int getArgbPre(IntBuffer buffer, int offset) {
            return PixelUtils.NonPretoPre(buffer.get(offset));
        }

        @Override
        public void setArgb(int[] arr, int offset, int argb) {
            arr[offset] = argb;
        }

        @Override
        public void setArgbPre(int[] arr, int offset, int argbpre) {
            arr[offset] = PixelUtils.PretoNonPre(argbpre);
        }

        @Override
        public void setArgb(IntBuffer buffer, int offset, int argb) {
            buffer.put(offset, argb);
        }

        @Override
        public void setArgbPre(IntBuffer buffer, int offset, int argbpre) {
            buffer.put(offset, PixelUtils.PretoNonPre(argbpre));
        }
    }
}

