/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.mac.MacPasteboard;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MacSystemClipboard
extends SystemClipboard {
    static final String FILE_SCHEME = "file";
    private static final String BAD_URI_MSG = "bad URI in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    private static final String BAD_URL_MSG = "bad URL in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    static final boolean SUPPORT_10_5_API = true;
    static final boolean SUPPORT_10_5_API_FORCE = false;
    static final boolean SUPPORT_10_6_API = false;
    long seed = 0L;
    final MacPasteboard pasteboard;

    public MacSystemClipboard(String name) {
        super(name);
        switch (name) {
            case "DND": {
                this.pasteboard = new MacPasteboard(2);
                break;
            }
            case "SYSTEM": {
                this.pasteboard = new MacPasteboard(1);
                break;
            }
            default: {
                this.pasteboard = new MacPasteboard(name);
            }
        }
    }

    @Override
    protected boolean isOwner() {
        return this.seed == this.pasteboard.getSeed();
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        return this.pasteboard.getAllowedOperation();
    }

    @Override
    protected void pushTargetActionToSystem(int actionDone) {
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> data, int supportedActions) {
        HashMap<String, byte[]> itemFirst = null;
        HashMap[] itemList = null;
        block19: for (String mime : data.keySet()) {
            Object object = data.get(mime);
            if (object == null) continue;
            switch (mime) {
                case "text/uri-list": {
                    List<HashMap<String, Object>> items = this.putToItemList(((String)object).split("\n"), true);
                    if (items.isEmpty()) continue block19;
                    itemList = new HashMap[items.size()];
                    items.toArray(itemList);
                    break;
                }
                case "application/x-java-rawimage": 
                case "application/x-java-drag-image": {
                    Pixels pixels = null;
                    if (object instanceof Pixels) {
                        pixels = (Pixels)object;
                    } else if (object instanceof ByteBuffer) {
                        try {
                            ByteBuffer bb = (ByteBuffer)object;
                            bb.rewind();
                            pixels = Application.GetApplication().createPixels(bb.getInt(), bb.getInt(), bb.slice());
                        }
                        catch (Exception bb) {}
                    } else if (object instanceof IntBuffer) {
                        try {
                            IntBuffer ib = (IntBuffer)object;
                            ib.rewind();
                            pixels = Application.GetApplication().createPixels(ib.get(), ib.get(), ib.slice());
                        }
                        catch (Exception ib) {}
                    } else {
                        throw new RuntimeException(object.getClass().getName() + " cannot be converted to Pixels");
                    }
                    if (pixels == null) continue block19;
                    if (itemFirst == null) {
                        itemFirst = new HashMap();
                    }
                    itemFirst.put(FormatEncoder.mimeToUtf(mime), (byte[])pixels);
                    break;
                }
                case "text/plain": 
                case "text/html": 
                case "text/rtf": {
                    if (object instanceof String) {
                        String string = (String)object;
                        if (itemFirst == null) {
                            itemFirst = new HashMap();
                        }
                        itemFirst.put(FormatEncoder.mimeToUtf(mime), (byte[])string);
                        break;
                    }
                    System.err.println("DelayedCallback not implemented yet: RT-14593");
                    Thread.dumpStack();
                    break;
                }
                case "application/x-java-file-list": {
                    String[] files = (String[])object;
                    if (data.get("text/uri-list") == null) {
                        List<HashMap<String, Object>> items = this.putToItemList(files, true);
                        if (items.isEmpty()) continue block19;
                        itemList = new HashMap[items.size()];
                        items.toArray(itemList);
                        break;
                    }
                    if (itemFirst == null) {
                        itemFirst = new HashMap();
                    }
                    StringBuilder string = null;
                    for (int i = 0; i < files.length; ++i) {
                        String file = files[i];
                        String path = FileSystems.getDefault().getPath(file, new String[0]).toUri().toASCIIString();
                        if (string == null) {
                            string = new StringBuilder();
                        }
                        string.append(path);
                        if (i >= files.length - 1) continue;
                        string.append("\n");
                    }
                    if (string == null) continue block19;
                    if (itemFirst.get("public.utf8-plain-text") != null) break;
                    itemFirst.remove("public.utf8-plain-text");
                    itemFirst.put("public.utf8-plain-text", (byte[])string.toString());
                    break;
                }
                default: {
                    if (itemFirst == null) {
                        itemFirst = new HashMap<String, byte[]>();
                    }
                    itemFirst.put(FormatEncoder.mimeToUtf(mime), this.serialize(object));
                }
            }
        }
        if (itemFirst != null) {
            if (itemList == null || itemList.length == 0) {
                itemList = new HashMap[]{itemFirst};
            } else {
                itemList[0].putAll(itemFirst);
            }
        }
        if (itemList != null) {
            this.seed = this.pasteboard.putItems(itemList, supportedActions);
        }
    }

    @Override
    protected Object popFromSystem(String mime) {
        String[][] utfs = this.pasteboard.getUTFs();
        if (utfs == null) {
            return null;
        }
        switch (mime) {
            case "application/x-java-rawimage": {
                ArrayList<Pixels> list = new ArrayList<Pixels>();
                for (int i = 0; i < utfs.length; ++i) {
                    byte[] data = this.pasteboard.getItemAsRawImage(i);
                    if (data == null) continue;
                    Pixels pixels = this.getPixelsForRawImage(data);
                    list.add(pixels);
                    break;
                }
                return this.getObjectFromList(list);
            }
            case "text/plain": 
            case "text/html": 
            case "text/rtf": 
            case "text/uri-list": {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < utfs.length; ++i) {
                    String item = this.pasteboard.getItemStringForUTF(i, FormatEncoder.mimeToUtf(mime));
                    if (item == null) continue;
                    list.add(item);
                    break;
                }
                return this.getObjectFromList(list);
            }
            case "application/x-java-file-list": {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < utfs.length; ++i) {
                    String file = this.pasteboard.getItemStringForUTF(i, "public.file-url");
                    if (file == null) continue;
                    list.add(MacSystemClipboard._convertFileReferencePath(file));
                }
                String[] object = null;
                if (list.size() > 0) {
                    object = new String[list.size()];
                    list.toArray(object);
                }
                return object;
            }
        }
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        for (int i = 0; i < utfs.length; ++i) {
            byte[] data = this.pasteboard.getItemBytesForUTF(i, FormatEncoder.mimeToUtf(mime));
            if (data == null) continue;
            ByteBuffer bb = ByteBuffer.wrap(data);
            list.add(bb);
            break;
        }
        return this.getObjectFromList(list);
    }

    private Object getObjectFromList(List<?> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    protected String[] mimesFromSystem() {
        String[][] all = this.pasteboard.getUTFs();
        ArrayList<String> mimes = new ArrayList<String>();
        if (all != null) {
            for (String[] utfs : all) {
                if (utfs == null) continue;
                for (String utf : utfs) {
                    String mime = FormatEncoder.utfToMime(utf);
                    if (mime == null || mimes.contains(mime)) continue;
                    mimes.add(mime);
                }
            }
        }
        String[] strings = new String[mimes.size()];
        mimes.toArray(strings);
        return strings;
    }

    @Override
    public String toString() {
        return "Mac OS X " + this.pasteboard.getName() + " Clipboard";
    }

    private URI createUri(String path, String message) {
        URI uri = null;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException ex) {
            System.err.println(message + path);
            Thread.dumpStack();
        }
        return uri;
    }

    private HashMap<String, Object> getItemFromURIString(String string) {
        String utf;
        String path = null;
        if (string.indexOf(58) == -1) {
            utf = "public.file-url";
            path = FileSystems.getDefault().getPath(string, new String[0]).toUri().toASCIIString();
        } else {
            utf = "public.url";
            URI uri = this.createUri(string, BAD_URI_MSG);
            if (uri != null) {
                path = uri.toASCIIString();
            }
        }
        if (path != null) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(utf, path);
            return item;
        }
        return null;
    }

    private List<HashMap<String, Object>> putToItemList(String[] items, boolean excludeComments) {
        ArrayList<HashMap<String, Object>> uriList = new ArrayList<HashMap<String, Object>>();
        for (String file : items) {
            HashMap<String, Object> entry;
            if (excludeComments && file.startsWith("#") || (entry = this.getItemFromURIString(file)) == null) continue;
            uriList.add(entry);
        }
        return uriList;
    }

    private static native String _convertFileReferencePath(String var0);

    private byte[] serialize(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.getBytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            return buffer.array();
        }
        throw new RuntimeException("can not handle " + object);
    }

    private static class FormatEncoder {
        private static final String DYNAMIC_UTI_PREFIX = "dyn.";
        private static final Map<String, String> utm = new HashMap<String, String>();
        private static final Map<String, String> mtu = new HashMap<String, String>();

        private FormatEncoder() {
        }

        public static synchronized String mimeToUtf(String mime) {
            if (mtu.containsKey(mime)) {
                return mtu.get(mime);
            }
            String encodedUTI = FormatEncoder._convertMIMEtoUTI(mime);
            mtu.put(mime, encodedUTI);
            utm.put(encodedUTI, mime);
            return encodedUTI;
        }

        public static synchronized String utfToMime(String uti) {
            if (utm.containsKey(uti)) {
                return utm.get(uti);
            }
            if (uti.startsWith(DYNAMIC_UTI_PREFIX)) {
                String decodedMIME = FormatEncoder._convertUTItoMIME(uti);
                mtu.put(decodedMIME, uti);
                utm.put(uti, decodedMIME);
                return decodedMIME;
            }
            return null;
        }

        private static native String _convertMIMEtoUTI(String var0);

        private static native String _convertUTItoMIME(String var0);

        static {
            utm.put("public.utf8-plain-text", "text/plain");
            utm.put("public.html", "text/html");
            utm.put("public.rtf", "text/rtf");
            utm.put("public.url", "text/uri-list");
            utm.put("public.file-url", "application/x-java-file-list");
            utm.put("public.tiff", "application/x-java-rawimage");
            utm.put("public.png", "application/x-java-rawimage");
            utm.put("application.x-java-rawimage", "application/x-java-rawimage");
            utm.put("application.x-java-drag-image", "application/x-java-drag-image");
            utm.put("application.x-java-drag-image-offset", "application/x-java-drag-image-offset");
            mtu.put("text/plain", "public.utf8-plain-text");
            mtu.put("text/html", "public.html");
            mtu.put("text/rtf", "public.rtf");
            mtu.put("text/uri-list", "public.url");
            mtu.put("application/x-java-file-list", "public.file-url");
            mtu.put("application/x-java-rawimage", "application.x-java-rawimage");
            mtu.put("application/x-java-drag-image", "application.x-java-drag-image");
            mtu.put("application/x-java-drag-image-offset", "application.x-java-drag-image-offset");
        }
    }
}

