/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.PixelConverter;
import com.sun.javafx.image.PixelGetter;
import com.sun.javafx.image.PixelSetter;
import com.sun.javafx.image.impl.ByteBgr;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.image.impl.ByteIndexed;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.javafx.image.impl.General;
import com.sun.javafx.image.impl.IntArgb;
import com.sun.javafx.image.impl.IntArgbPre;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritablePixelFormat;

public class PixelUtils {
    private PixelUtils() {
    }

    public static int RgbToGray(int r, int g, int b) {
        return (int)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
    }

    public static int RgbToGray(int xrgb) {
        return PixelUtils.RgbToGray(xrgb >> 16 & 0xFF, xrgb >> 8 & 0xFF, xrgb & 0xFF);
    }

    public static int NonPretoPre(int nonpre, int alpha) {
        if (alpha == 255) {
            return nonpre;
        }
        if (alpha == 0) {
            return 0;
        }
        return (nonpre * alpha + 127) / 255;
    }

    public static int PreToNonPre(int pre, int alpha) {
        if (alpha == 255 || alpha == 0) {
            return pre;
        }
        return pre >= alpha ? 255 : (pre * 255 + (alpha >> 1)) / alpha;
    }

    public static int NonPretoPre(int nonpre) {
        int a = nonpre >>> 24;
        if (a == 255) {
            return nonpre;
        }
        if (a == 0) {
            return 0;
        }
        int r = nonpre >> 16 & 0xFF;
        int g = nonpre >> 8 & 0xFF;
        int b = nonpre & 0xFF;
        r = (r * a + 127) / 255;
        g = (g * a + 127) / 255;
        b = (b * a + 127) / 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int PretoNonPre(int pre) {
        int a = pre >>> 24;
        if (a == 255 || a == 0) {
            return pre;
        }
        int r = pre >> 16 & 0xFF;
        int g = pre >> 8 & 0xFF;
        int b = pre & 0xFF;
        int halfa = a >> 1;
        r = r >= a ? 255 : (r * 255 + halfa) / a;
        g = g >= a ? 255 : (g * 255 + halfa) / a;
        b = b >= a ? 255 : (b * 255 + halfa) / a;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static BytePixelGetter getByteGetter(PixelFormat<ByteBuffer> pf) {
        switch (pf.getType()) {
            case BYTE_BGRA: {
                return ByteBgra.getter;
            }
            case BYTE_BGRA_PRE: {
                return ByteBgraPre.getter;
            }
            case BYTE_RGB: {
                return ByteRgb.getter;
            }
            case BYTE_INDEXED: {
                return ByteIndexed.createGetter(pf);
            }
        }
        return null;
    }

    public static IntPixelGetter getIntGetter(PixelFormat<IntBuffer> pf) {
        switch (pf.getType()) {
            case INT_ARGB: {
                return IntArgb.getter;
            }
            case INT_ARGB_PRE: {
                return IntArgbPre.getter;
            }
        }
        return null;
    }

    public static <T extends Buffer> PixelGetter<T> getGetter(PixelFormat<T> pf) {
        switch (pf.getType()) {
            case BYTE_BGRA: 
            case BYTE_BGRA_PRE: 
            case BYTE_RGB: 
            case BYTE_INDEXED: {
                return PixelUtils.getByteGetter(pf);
            }
            case INT_ARGB: 
            case INT_ARGB_PRE: {
                return PixelUtils.getIntGetter(pf);
            }
        }
        return null;
    }

    public static BytePixelSetter getByteSetter(WritablePixelFormat<ByteBuffer> pf) {
        switch (pf.getType()) {
            case BYTE_BGRA: {
                return ByteBgra.setter;
            }
            case BYTE_BGRA_PRE: {
                return ByteBgraPre.setter;
            }
        }
        return null;
    }

    public static IntPixelSetter getIntSetter(WritablePixelFormat<IntBuffer> pf) {
        switch (pf.getType()) {
            case INT_ARGB: {
                return IntArgb.setter;
            }
            case INT_ARGB_PRE: {
                return IntArgbPre.setter;
            }
        }
        return null;
    }

    public static <T extends Buffer> PixelSetter<T> getSetter(WritablePixelFormat<T> pf) {
        switch (pf.getType()) {
            case BYTE_BGRA: 
            case BYTE_BGRA_PRE: {
                return PixelUtils.getByteSetter(pf);
            }
            case INT_ARGB: 
            case INT_ARGB_PRE: {
                return PixelUtils.getIntSetter(pf);
            }
        }
        return null;
    }

    public static <T extends Buffer, U extends Buffer> PixelConverter<T, U> getConverter(PixelGetter<T> src, PixelSetter<U> dst) {
        if (src instanceof BytePixelGetter) {
            if (dst instanceof BytePixelSetter) {
                return PixelUtils.getB2BConverter((BytePixelGetter)src, (BytePixelSetter)dst);
            }
            return PixelUtils.getB2IConverter((BytePixelGetter)src, (IntPixelSetter)dst);
        }
        if (dst instanceof BytePixelSetter) {
            return PixelUtils.getI2BConverter((IntPixelGetter)src, (BytePixelSetter)dst);
        }
        return PixelUtils.getI2IConverter((IntPixelGetter)src, (IntPixelSetter)dst);
    }

    public static ByteToBytePixelConverter getB2BConverter(PixelGetter<ByteBuffer> src, PixelSetter<ByteBuffer> dst) {
        if (src == ByteBgra.getter) {
            if (dst == ByteBgra.setter) {
                return ByteBgra.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return ByteBgra.ToByteBgraPreConverter();
            }
        } else if (src == ByteBgraPre.getter) {
            if (dst == ByteBgra.setter) {
                return ByteBgraPre.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return ByteBgraPre.ToByteBgraPreConverter();
            }
        } else if (src == ByteRgb.getter) {
            if (dst == ByteBgra.setter) {
                return ByteRgb.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return ByteRgb.ToByteBgraPreConverter();
            }
            if (dst == ByteBgr.setter) {
                return ByteRgb.ToByteBgrConverter();
            }
        } else if (src == ByteBgr.getter) {
            if (dst == ByteBgr.setter) {
                return ByteBgr.ToByteBgrConverter();
            }
            if (dst == ByteBgra.setter) {
                return ByteBgr.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return ByteBgr.ToByteBgraPreConverter();
            }
        } else if (src == ByteGray.getter) {
            if (dst == ByteGray.setter) {
                return ByteGray.ToByteGrayConverter();
            }
            if (dst == ByteBgr.setter) {
                return ByteGray.ToByteBgrConverter();
            }
            if (dst == ByteBgra.setter) {
                return ByteGray.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return ByteGray.ToByteBgraPreConverter();
            }
        } else if (src instanceof ByteIndexed.Getter && (dst == ByteBgra.setter || dst == ByteBgraPre.setter)) {
            return ByteIndexed.createToByteBgraAny((BytePixelGetter)src, (BytePixelSetter)dst);
        }
        if (dst == ByteGray.setter) {
            return null;
        }
        if (src.getAlphaType() != AlphaType.OPAQUE && dst.getAlphaType() == AlphaType.OPAQUE) {
            return null;
        }
        return General.create((BytePixelGetter)src, (BytePixelSetter)dst);
    }

    public static ByteToIntPixelConverter getB2IConverter(PixelGetter<ByteBuffer> src, PixelSetter<IntBuffer> dst) {
        if (src == ByteBgra.getter) {
            if (dst == IntArgb.setter) {
                return ByteBgra.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return ByteBgra.ToIntArgbPreConverter();
            }
        } else if (src == ByteBgraPre.getter) {
            if (dst == IntArgb.setter) {
                return ByteBgraPre.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return ByteBgraPre.ToIntArgbPreConverter();
            }
        } else if (src == ByteRgb.getter) {
            if (dst == IntArgb.setter) {
                return ByteRgb.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return ByteRgb.ToIntArgbPreConverter();
            }
        } else if (src == ByteBgr.getter) {
            if (dst == IntArgb.setter) {
                return ByteBgr.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return ByteBgr.ToIntArgbPreConverter();
            }
        } else if (src == ByteGray.getter) {
            if (dst == IntArgbPre.setter) {
                return ByteGray.ToIntArgbPreConverter();
            }
            if (dst == IntArgb.setter) {
                return ByteGray.ToIntArgbConverter();
            }
        } else if (src instanceof ByteIndexed.Getter && (dst == IntArgb.setter || dst == IntArgbPre.setter)) {
            return ByteIndexed.createToIntArgbAny((BytePixelGetter)src, (IntPixelSetter)dst);
        }
        if (src.getAlphaType() != AlphaType.OPAQUE && dst.getAlphaType() == AlphaType.OPAQUE) {
            return null;
        }
        return General.create((BytePixelGetter)src, (IntPixelSetter)dst);
    }

    public static IntToBytePixelConverter getI2BConverter(PixelGetter<IntBuffer> src, PixelSetter<ByteBuffer> dst) {
        if (src == IntArgb.getter) {
            if (dst == ByteBgra.setter) {
                return IntArgb.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return IntArgb.ToByteBgraPreConverter();
            }
        } else if (src == IntArgbPre.getter) {
            if (dst == ByteBgra.setter) {
                return IntArgbPre.ToByteBgraConverter();
            }
            if (dst == ByteBgraPre.setter) {
                return IntArgbPre.ToByteBgraPreConverter();
            }
        }
        if (dst == ByteGray.setter) {
            return null;
        }
        if (src.getAlphaType() != AlphaType.OPAQUE && dst.getAlphaType() == AlphaType.OPAQUE) {
            return null;
        }
        return General.create((IntPixelGetter)src, (BytePixelSetter)dst);
    }

    public static IntToIntPixelConverter getI2IConverter(PixelGetter<IntBuffer> src, PixelSetter<IntBuffer> dst) {
        if (src == IntArgb.getter) {
            if (dst == IntArgb.setter) {
                return IntArgb.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return IntArgb.ToIntArgbPreConverter();
            }
        } else if (src == IntArgbPre.getter) {
            if (dst == IntArgb.setter) {
                return IntArgbPre.ToIntArgbConverter();
            }
            if (dst == IntArgbPre.setter) {
                return IntArgbPre.ToIntArgbPreConverter();
            }
        }
        if (src.getAlphaType() != AlphaType.OPAQUE && dst.getAlphaType() == AlphaType.OPAQUE) {
            return null;
        }
        return General.create((IntPixelGetter)src, (IntPixelSetter)dst);
    }
}

