/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.IntPixelSetter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public abstract class BaseByteToIntConverter
implements ByteToIntPixelConverter {
    protected final BytePixelGetter getter;
    protected final IntPixelSetter setter;
    protected final int nSrcElems;

    BaseByteToIntConverter(BytePixelGetter getter, IntPixelSetter setter) {
        this.getter = getter;
        this.setter = setter;
        this.nSrcElems = getter.getNumElements();
    }

    public final BytePixelGetter getGetter() {
        return this.getter;
    }

    public final IntPixelSetter getSetter() {
        return this.setter;
    }

    abstract void doConvert(byte[] var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8);

    abstract void doConvert(ByteBuffer var1, int var2, int var3, IntBuffer var4, int var5, int var6, int var7, int var8);

    @Override
    public final void convert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanints == w) {
            w *= h;
            h = 1;
        }
        this.doConvert(srcarr, srcoff, srcscanbytes, dstarr, dstoff, dstscanints, w, h);
    }

    @Override
    public final void convert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanints == w) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray() && dstbuf.hasArray()) {
            this.doConvert(srcbuf.array(), srcoff += srcbuf.arrayOffset(), srcscanbytes, dstbuf.array(), dstoff += dstbuf.arrayOffset(), dstscanints, w, h);
        } else {
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanints, w, h);
        }
    }

    @Override
    public final void convert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanints == w) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray()) {
            byte[] srcarr = srcbuf.array();
            this.doConvert(srcarr, srcoff += srcbuf.arrayOffset(), srcscanbytes, dstarr, dstoff, dstscanints, w, h);
        } else {
            IntBuffer dstbuf = IntBuffer.wrap(dstarr);
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanints, w, h);
        }
    }

    @Override
    public final void convert(byte[] srcarr, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanints == w) {
            w *= h;
            h = 1;
        }
        if (dstbuf.hasArray()) {
            int[] dstarr = dstbuf.array();
            this.doConvert(srcarr, srcoff, srcscanbytes, dstarr, dstoff += dstbuf.arrayOffset(), dstscanints, w, h);
        } else {
            ByteBuffer srcbuf = ByteBuffer.wrap(srcarr);
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanints, w, h);
        }
    }
}

