/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.EventImpl;
import com.sun.webkit.dom.EventListenerImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class EventTargetImpl
implements EventTarget {
    private final long peer;

    EventTargetImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static EventTarget create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new EventTargetImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof EventTargetImpl && this.peer == ((EventTargetImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(EventTarget arg) {
        return arg == null ? 0L : ((EventTargetImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static EventTarget getImpl(long peer) {
        return EventTargetImpl.create(peer);
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        EventTargetImpl.addEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener), useCapture);
    }

    static native void addEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        EventTargetImpl.removeEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener), useCapture);
    }

    static native void removeEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public boolean dispatchEvent(Event event) throws DOMException {
        return EventTargetImpl.dispatchEventImpl(this.getPeer(), EventImpl.getPeer(event));
    }

    static native boolean dispatchEventImpl(long var0, long var2);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            EventTargetImpl.dispose(this.peer);
        }
    }
}

