/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import com.sun.javafx.property.PropertyReference;
import com.sun.javafx.scene.control.Logging;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import sun.util.logging.PlatformLogger;

public class TreeItemPropertyValueFactory<S, T>
implements Callback<TreeTableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
    private final String property;
    private Class<?> columnClass;
    private String previousProperty;
    private PropertyReference<T> propertyRef;

    public TreeItemPropertyValueFactory(@NamedArg(value="property") String property) {
        this.property = property;
    }

    @Override
    public ObservableValue<T> call(TreeTableColumn.CellDataFeatures<S, T> param) {
        TreeItem<S> treeItem = param.getValue();
        return this.getCellDataReflectively(treeItem.getValue());
    }

    public final String getProperty() {
        return this.property;
    }

    private ObservableValue<T> getCellDataReflectively(S rowData) {
        if (this.getProperty() == null || this.getProperty().isEmpty() || rowData == null) {
            return null;
        }
        try {
            if (this.columnClass == null || this.previousProperty == null || !this.columnClass.equals(rowData.getClass()) || !this.previousProperty.equals(this.getProperty())) {
                this.columnClass = rowData.getClass();
                this.previousProperty = this.getProperty();
                this.propertyRef = new PropertyReference(rowData.getClass(), this.getProperty());
            }
            return this.propertyRef.getProperty(rowData);
        }
        catch (IllegalStateException e) {
            try {
                T value = this.propertyRef.get(rowData);
                return new ReadOnlyObjectWrapper<T>(value);
            }
            catch (IllegalStateException value) {
                PlatformLogger logger = Logging.getControlsLogger();
                if (logger.isLoggable(PlatformLogger.Level.WARNING)) {
                    logger.finest("Can not retrieve property '" + this.getProperty() + "' in TreeItemPropertyValueFactory: " + this + " with provided class type: " + rowData.getClass(), e);
                }
                return null;
            }
        }
    }
}

