/*
 * Decompiled with CFR 0.152.
 */
package javafx.util;

import java.io.Serializable;
import javafx.beans.NamedArg;

public class Duration
implements Comparable<Duration>,
Serializable {
    public static final Duration ZERO = new Duration(0.0);
    public static final Duration ONE = new Duration(1.0);
    public static final Duration INDEFINITE = new Duration(Double.POSITIVE_INFINITY);
    public static final Duration UNKNOWN = new Duration(Double.NaN);
    private final double millis;

    public static Duration valueOf(String time) {
        int index = -1;
        for (int i = 0; i < time.length(); ++i) {
            char c = time.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '-') continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("The time parameter must have a suffix of [ms|s|m|h]");
        }
        double value = Double.parseDouble(time.substring(0, index));
        String suffix = time.substring(index);
        if ("ms".equals(suffix)) {
            return Duration.millis(value);
        }
        if ("s".equals(suffix)) {
            return Duration.seconds(value);
        }
        if ("m".equals(suffix)) {
            return Duration.minutes(value);
        }
        if ("h".equals(suffix)) {
            return Duration.hours(value);
        }
        throw new IllegalArgumentException("The time parameter must have a suffix of [ms|s|m|h]");
    }

    public static Duration millis(double ms) {
        if (ms == 0.0) {
            return ZERO;
        }
        if (ms == 1.0) {
            return ONE;
        }
        if (ms == Double.POSITIVE_INFINITY) {
            return INDEFINITE;
        }
        if (Double.isNaN(ms)) {
            return UNKNOWN;
        }
        return new Duration(ms);
    }

    public static Duration seconds(double s) {
        if (s == 0.0) {
            return ZERO;
        }
        if (s == Double.POSITIVE_INFINITY) {
            return INDEFINITE;
        }
        if (Double.isNaN(s)) {
            return UNKNOWN;
        }
        return new Duration(s * 1000.0);
    }

    public static Duration minutes(double m) {
        if (m == 0.0) {
            return ZERO;
        }
        if (m == Double.POSITIVE_INFINITY) {
            return INDEFINITE;
        }
        if (Double.isNaN(m)) {
            return UNKNOWN;
        }
        return new Duration(m * 60000.0);
    }

    public static Duration hours(double h) {
        if (h == 0.0) {
            return ZERO;
        }
        if (h == Double.POSITIVE_INFINITY) {
            return INDEFINITE;
        }
        if (Double.isNaN(h)) {
            return UNKNOWN;
        }
        return new Duration(h * 3600000.0);
    }

    public Duration(@NamedArg(value="millis") double millis) {
        this.millis = millis;
    }

    public double toMillis() {
        return this.millis;
    }

    public double toSeconds() {
        return this.millis / 1000.0;
    }

    public double toMinutes() {
        return this.millis / 60000.0;
    }

    public double toHours() {
        return this.millis / 3600000.0;
    }

    public Duration add(Duration other) {
        return Duration.millis(this.millis + other.millis);
    }

    public Duration subtract(Duration other) {
        return Duration.millis(this.millis - other.millis);
    }

    @Deprecated
    public Duration multiply(Duration other) {
        return Duration.millis(this.millis * other.millis);
    }

    public Duration multiply(double n) {
        return Duration.millis(this.millis * n);
    }

    public Duration divide(double n) {
        return Duration.millis(this.millis / n);
    }

    @Deprecated
    public Duration divide(Duration other) {
        return Duration.millis(this.millis / other.millis);
    }

    public Duration negate() {
        return Duration.millis(-this.millis);
    }

    public boolean isIndefinite() {
        return this.millis == Double.POSITIVE_INFINITY;
    }

    public boolean isUnknown() {
        return Double.isNaN(this.millis);
    }

    public boolean lessThan(Duration other) {
        return this.millis < other.millis;
    }

    public boolean lessThanOrEqualTo(Duration other) {
        return this.millis <= other.millis;
    }

    public boolean greaterThan(Duration other) {
        return this.millis > other.millis;
    }

    public boolean greaterThanOrEqualTo(Duration other) {
        return this.millis >= other.millis;
    }

    public String toString() {
        return this.isIndefinite() ? "INDEFINITE" : (this.isUnknown() ? "UNKNOWN" : this.millis + " ms");
    }

    @Override
    public int compareTo(Duration d) {
        return Double.compare(this.millis, d.millis);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Duration && this.millis == ((Duration)obj).millis;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.millis);
        return (int)(bits ^ bits >>> 32);
    }
}

