/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FileSystem {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_FILE = 1;
    private static final int TYPE_DIRECTORY = 2;
    private static final Logger logger = Logger.getLogger(FileSystem.class.getName());

    private FileSystem() {
        throw new AssertionError();
    }

    private static boolean fwkFileExists(String path) {
        return new File(path).exists();
    }

    private static long fwkGetFileSize(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return file.length();
            }
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, String.format("Error determining size of file [%s]", path), ex);
        }
        return -1L;
    }

    private static boolean fwkGetFileMetadata(String path, long[] metadataArray) {
        try {
            File file = new File(path);
            if (file.exists()) {
                metadataArray[0] = file.lastModified();
                metadataArray[1] = file.length();
                metadataArray[2] = file.isDirectory() ? 2L : (file.isFile() ? 1L : 0L);
                return true;
            }
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, String.format("Error determining Metadata for file [%s]", path), ex);
        }
        return false;
    }

    private static String fwkPathByAppendingComponent(String path, String component) {
        return new File(path, component).getPath();
    }

    private static boolean fwkMakeAllDirectories(String path) {
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (IOException | InvalidPathException ex) {
            logger.log(Level.FINE, String.format("Error creating directory [%s]", path), ex);
            return false;
        }
    }

    private static String fwkPathGetFileName(String path) {
        return new File(path).getName();
    }
}

