/*
 * Decompiled with CFR 0.152.
 */
package jdk.packager.services.userjvmoptions;

import java.security.AllPermission;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import jdk.packager.services.UserJvmOptionsService;

public final class LauncherUserJvmOptions
implements UserJvmOptionsService {
    private static final Object semaphore = new Object();

    private static void checkAllPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
    }

    private static native String _getUserJvmOptionDefaultValue(String var0);

    private static native String[] _getUserJvmOptionDefaultKeys();

    private static native String _getUserJvmOptionValue(String var0);

    private static native void _setUserJvmKeysAndValues(String[] var0, String[] var1);

    private static native String[] _getUserJvmOptionKeys();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUserJVMOptions() {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            for (String s : LauncherUserJvmOptions._getUserJvmOptionKeys()) {
                results.put(s, LauncherUserJvmOptions._getUserJvmOptionValue(s));
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserJVMOptions(Map<String, String> options) {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedList<String> keys = new LinkedList<String>();
            LinkedList<String> values = new LinkedList<String>();
            for (Map.Entry<String, String> option : options.entrySet()) {
                if (option.getKey() == null) {
                    throw new IllegalArgumentException("For Launcher Backed UserJVMOptions keys in the UserJVMOptions map cannot be null.");
                }
                if (option.getValue() == null) {
                    throw new IllegalArgumentException("For Launcher Backed UserJVMOptions values in the UserJVMOptions map cannot be null.  Keys are removed by absence, not by setting keys to null.");
                }
                keys.add(option.getKey());
                values.add(option.getValue());
            }
            LauncherUserJvmOptions._setUserJvmKeysAndValues(keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUserJVMOptionDefaults() {
        LauncherUserJvmOptions.checkAllPermissions();
        Object object = semaphore;
        synchronized (object) {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            for (String s : LauncherUserJvmOptions._getUserJvmOptionDefaultKeys()) {
                results.put(s, LauncherUserJvmOptions._getUserJvmOptionDefaultValue(s));
            }
            return results;
        }
    }

    static {
        try {
            LauncherUserJvmOptions.checkAllPermissions();
            System.loadLibrary("packager");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

