/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacDaemonBundler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class MacBaseInstallerBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacBaseInstallerBundler.class.getName());
    public static final BundlerParamInfo<MacAppBundler> APP_BUNDLER = new StandardBundlerParam<MacAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundle.description"), "mac.app.bundler", MacAppBundler.class, params -> new MacAppBundler(), (s, p) -> null);
    public final BundlerParamInfo<File> APP_IMAGE_BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.app-image-build-root.name"), I18N.getString("param.app-image-build-root.description"), "mac.app.imageRoot", File.class, params -> {
        File imageDir = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imageDir.exists()) {
            imageDir.mkdirs();
        }
        try {
            return Files.createTempDirectory(imageDir.toPath(), "image-", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            return new File(imageDir, this.getID() + ".image");
        }
    }, (s, p) -> new File((String)s));
    public static final StandardBundlerParam<File> MAC_APP_IMAGE = new StandardBundlerParam<File>(I18N.getString("param.app-image.name"), I18N.getString("param.app-image.description"), "mac.app.image", File.class, params -> null, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<MacDaemonBundler> DAEMON_BUNDLER = new StandardBundlerParam<MacDaemonBundler>(I18N.getString("param.daemon-bundler.name"), I18N.getString("param.daemon-bundler.description"), "mac.daemon.bundler", MacDaemonBundler.class, params -> new MacDaemonBundler(), (s, p) -> null);
    public final BundlerParamInfo<File> DAEMON_IMAGE_BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.daemon-image-build-root.name"), I18N.getString("param.daemon-image-build-root.description"), "mac.daemon.image", File.class, params -> {
        File imageDir = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imageDir.exists()) {
            imageDir.mkdirs();
        }
        return new File(imageDir, this.getID() + ".daemon");
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File imagesRoot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "macosx");
        imagesRoot.mkdirs();
        return imagesRoot;
    }, (s, p) -> null);
    public static final BundlerParamInfo<String> SIGNING_KEY_USER = new StandardBundlerParam<String>(I18N.getString("param.signing-key-name.name"), I18N.getString("param.signing-key-name.description"), "mac.signing-key-user-name", String.class, params -> "", null);
    public static final BundlerParamInfo<String> SIGNING_KEYCHAIN = new StandardBundlerParam<String>(I18N.getString("param.signing-keychain.name"), I18N.getString("param.signing-keychain.description"), "mac.signing-keychain", String.class, params -> "", null);
    public static final BundlerParamInfo<String> INSTALLER_NAME = new StandardBundlerParam<String>(I18N.getString("param.installer-name.name"), I18N.getString("param.installer-name.description"), "mac.installerName", String.class, params -> {
        String nm = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)params);
        if (nm == null) {
            return null;
        }
        String version = (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)params);
        if (version == null) {
            return nm;
        }
        return nm + "-" + version;
    }, (s, p) -> s);

    public static File getPredefinedImage(Map<String, ? super Object> p) {
        File applicationImage = null;
        if (MAC_APP_IMAGE.fetchFrom(p) != null) {
            applicationImage = (File)MAC_APP_IMAGE.fetchFrom(p);
            Log.debug("Using App Image from " + applicationImage);
            if (!applicationImage.exists()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist"), MAC_APP_IMAGE.getID(), applicationImage.toString()));
            }
        }
        return applicationImage;
    }

    protected void validateAppImageAndBundeler(Map<String, ? super Object> params) throws ConfigException, UnsupportedPlatformException {
        if (MAC_APP_IMAGE.fetchFrom(params) != null) {
            File applicationImage = (File)MAC_APP_IMAGE.fetchFrom(params);
            if (!applicationImage.exists()) {
                throw new ConfigException(MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist"), MAC_APP_IMAGE.getID(), applicationImage.toString()), MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist.advice"), MAC_APP_IMAGE.getID()));
            }
            if (StandardBundlerParam.APP_NAME.fetchFrom(params) == null) {
                throw new ConfigException(I18N.getString("message.app-image-requires-app-name"), I18N.getString("message.app-image-requires-app-name.advice"));
            }
            if (StandardBundlerParam.IDENTIFIER.fetchFrom(params) == null) {
                throw new ConfigException(I18N.getString("message.app-image-requires-identifier"), I18N.getString("message.app-image-requires-identifier.advice"));
            }
        } else {
            APP_BUNDLER.fetchFrom(params).doValidate(params);
        }
    }

    protected File prepareAppBundle(Map<String, ? super Object> p) {
        File predefinedImage = MacBaseInstallerBundler.getPredefinedImage(p);
        if (predefinedImage != null) {
            return predefinedImage;
        }
        File appImageRoot = this.APP_IMAGE_BUILD_ROOT.fetchFrom(p);
        return APP_BUNDLER.fetchFrom(p).doBundle(p, appImageRoot, true);
    }

    protected File prepareDaemonBundle(Map<String, ? super Object> p) {
        File daemonImageRoot = this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(p);
        return DAEMON_BUNDLER.fetchFrom(p).doBundle(p, daemonImageRoot, true);
    }

    public static void signAppBundle(Map<String, ? super Object> params, File appLocation, String signingIdentity, String identifierPrefix) throws IOException {
        MacBaseInstallerBundler.signAppBundle(params, appLocation, signingIdentity, identifierPrefix, null, null);
    }

    public static void signAppBundle(Map<String, ? super Object> params, File appLocation, String signingIdentity, String identifierPrefix, String entitlementsFile, String inheritedEntitlements) throws IOException {
        Path frameworkPath;
        AtomicReference toThrow = new AtomicReference();
        String appExecutable = "/Contents/MacOS/" + (String)StandardBundlerParam.APP_NAME.fetchFrom(params);
        String keyChain = SIGNING_KEYCHAIN.fetchFrom(params);
        Files.walk(appLocation.toPath(), new FileVisitOption[0]).peek(path -> {
            try {
                Set<PosixFilePermission> pfp = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (!pfp.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                    pfp = EnumSet.copyOf(pfp);
                    pfp.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(path, pfp);
                }
            }
            catch (IOException e) {
                Log.debug(e);
            }
        }).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && !p.toString().contains("/Contents/MacOS/libjli.dylib") && !p.toString().contains("/Contents/MacOS/JavaAppletPlugin") && !p.toString().endsWith(appExecutable)).forEach(p -> {
            if (toThrow.get() != null) {
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList("codesign", "-s", signingIdentity, "--prefix", identifierPrefix, "-vvvv"));
            if (entitlementsFile != null && (p.toString().endsWith(".jar") || p.toString().endsWith(".dylib"))) {
                args.add("--entitlements");
                args.add(entitlementsFile);
            } else if (inheritedEntitlements != null && Files.isExecutable(p)) {
                args.add("--entitlements");
                args.add(inheritedEntitlements);
            }
            if (keyChain != null && !keyChain.isEmpty()) {
                args.add("--keychain");
                args.add(keyChain);
            }
            args.add(p.toString());
            try {
                Set<PosixFilePermission> oldPermissions = Files.getPosixFilePermissions(p, new LinkOption[0]);
                File f = p.toFile();
                f.setWritable(true, true);
                ProcessBuilder pb = new ProcessBuilder(args);
                IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
                Files.setPosixFilePermissions(p, oldPermissions);
            }
            catch (IOException ioe) {
                toThrow.set(ioe);
            }
        });
        IOException ioe = (IOException)toThrow.get();
        if (ioe != null) {
            throw ioe;
        }
        Consumer<Path> signIdentifiedByPList = path -> {
            if (toThrow.get() != null) {
                return;
            }
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.addAll(Arrays.asList("codesign", "-s", signingIdentity, "--prefix", identifierPrefix, "-vvvv"));
                if (keyChain != null && !keyChain.isEmpty()) {
                    args.add("--keychain");
                    args.add(keyChain);
                }
                args.add(path.toString());
                ProcessBuilder pb = new ProcessBuilder(args);
                IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
                args = new ArrayList();
                args.addAll(Arrays.asList("codesign", "-s", signingIdentity, "--prefix", identifierPrefix, "-vvvv"));
                if (keyChain != null && !keyChain.isEmpty()) {
                    args.add("--keychain");
                    args.add(keyChain);
                }
                args.add(path.toString() + "/Contents/_CodeSignature/CodeResources");
                pb = new ProcessBuilder(args);
                IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            }
            catch (IOException e) {
                toThrow.set(e);
            }
        };
        Path pluginsPath = appLocation.toPath().resolve("Contents/PlugIns");
        if (Files.isDirectory(pluginsPath, new LinkOption[0])) {
            Files.list(pluginsPath).forEach(signIdentifiedByPList);
            ioe = (IOException)toThrow.get();
            if (ioe != null) {
                throw ioe;
            }
        }
        if (Files.isDirectory(frameworkPath = appLocation.toPath().resolve("Contents/Frameworks"), new LinkOption[0])) {
            Files.list(frameworkPath).forEach(signIdentifiedByPList);
            ioe = (IOException)toThrow.get();
            if (ioe != null) {
                throw ioe;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("codesign", "-s", signingIdentity, "-vvvv"));
        if (entitlementsFile != null) {
            args.add("--entitlements");
            args.add(entitlementsFile);
        }
        if (keyChain != null && !keyChain.isEmpty()) {
            args.add("--keychain");
            args.add(keyChain);
        }
        args.add(appLocation.toString());
        ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[args.size()]));
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(Arrays.asList(APP_BUNDLER, CONFIG_ROOT, this.APP_IMAGE_BUILD_ROOT, MAC_APP_IMAGE));
        return results;
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    /*
     * Exception decompiling
     */
    public static String findKey(String key, String keychainName, boolean verbose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

