/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.mac.MacApplication;
import com.sun.glass.ui.mac.MacVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.Font;

final class MacAccessible
extends Accessible {
    private static final List<MacAttribute> baseAttributes;
    private static final List<MacAttribute> textAttributes;
    private static final List<MacAttribute> textParameterizedAttributes;
    private long peer = this._createGlassAccessible();
    private static final int kAXMenuItemModifierNone = 0;
    private static final int kAXMenuItemModifierShift = 1;
    private static final int kAXMenuItemModifierOption = 2;
    private static final int kAXMenuItemModifierControl = 4;
    private static final int kAXMenuItemModifierNoCommand = 8;
    private Boolean inMenu;
    private Boolean inSlider;
    private Boolean ignoreInnerText;

    private static native void _initIDs();

    private static native boolean _initEnum(String var0);

    private native long _createGlassAccessible();

    private native void _destroyGlassAccessible(long var1);

    private static native String getString(long var0);

    private static native boolean isEqualToString(long var0, long var2);

    private static native long NSAccessibilityUnignoredAncestor(long var0);

    private static native long[] NSAccessibilityUnignoredChildren(long[] var0);

    private static native void NSAccessibilityPostNotification(long var0, long var2);

    private static native String NSAccessibilityActionDescription(long var0);

    private static native String NSAccessibilityRoleDescription(long var0, long var2);

    private static native MacVariant idToMacVariant(long var0, int var2);

    private static native MacAccessible GlassAccessibleToMacAccessible(long var0);

    MacAccessible() {
        if (this.peer == 0L) {
            throw new RuntimeException("could not create platform accessible");
        }
    }

    @Override
    public void dispose() {
        if (this.peer != 0L) {
            if (this.getView() == null) {
                MacAccessible.NSAccessibilityPostNotification(this.peer, MacNotification.NSAccessibilityUIElementDestroyedNotification.ptr);
            }
            this._destroyGlassAccessible(this.peer);
            this.peer = 0L;
        }
        super.dispose();
    }

    @Override
    public void sendNotification(AccessibleAttribute notification) {
        if (this.isDisposed()) {
            return;
        }
        MacNotification macNotification = null;
        switch (notification) {
            case FOCUS_ITEM: {
                AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (role == AccessibleRole.TABLE_VIEW || role == AccessibleRole.TREE_TABLE_VIEW) {
                    macNotification = MacNotification.NSAccessibilitySelectedCellsChangedNotification;
                    break;
                }
                if (role == AccessibleRole.LIST_VIEW || role == AccessibleRole.TREE_VIEW) {
                    macNotification = MacNotification.NSAccessibilitySelectedRowsChangedNotification;
                    break;
                }
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                long id = this.getNativeAccessible(node);
                if (id == 0L) break;
                MacAccessible.NSAccessibilityPostNotification(id, MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                break;
            }
            case FOCUS_NODE: {
                Accessible acc;
                Scene scene;
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                View view = this.getView();
                if (node == null && view == null && (scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0])) != null && (acc = this.getAccessible(scene)) != null) {
                    node = (Node)acc.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                }
                long id = 0L;
                if (node != null) {
                    Node item = (Node)this.getAccessible(node).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                    id = item != null ? this.getNativeAccessible(item) : this.getNativeAccessible(node);
                } else {
                    if (view == null) {
                        view = this.getRootView((Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]));
                    }
                    if (view != null) {
                        id = view.getNativeView();
                    }
                }
                if (id != 0L) {
                    MacAccessible.NSAccessibilityPostNotification(id, MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                }
                return;
            }
            case FOCUSED: {
                return;
            }
            case SELECTION_START: 
            case SELECTION_END: {
                macNotification = MacNotification.NSAccessibilitySelectedTextChangedNotification;
                break;
            }
            case EXPANDED: {
                AccessibleRole containerRole;
                MacAccessible container;
                boolean expanded = Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]));
                macNotification = expanded ? MacNotification.NSAccessibilityRowExpandedNotification : MacNotification.NSAccessibilityRowCollapsedNotification;
                AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (role != AccessibleRole.TREE_ITEM && role != AccessibleRole.TREE_TABLE_ROW || (container = (MacAccessible)this.getContainerAccessible(containerRole = role == AccessibleRole.TREE_ITEM ? AccessibleRole.TREE_VIEW : AccessibleRole.TREE_TABLE_VIEW)) == null) break;
                MacAccessible.NSAccessibilityPostNotification(container.getNativeAccessible(), MacNotification.NSAccessibilityRowCountChangedNotification.ptr);
                break;
            }
            case VISIBLE: {
                MacAccessible menu;
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.CONTEXT_MENU) break;
                Boolean visible = (Boolean)this.getAttribute(AccessibleAttribute.VISIBLE, new Object[0]);
                if (Boolean.TRUE.equals(visible)) {
                    macNotification = MacNotification.AXMenuOpened;
                    break;
                }
                macNotification = MacNotification.AXMenuClosed;
                Node menuItemOwner = (Node)this.getAttribute(AccessibleAttribute.PARENT_MENU, new Object[0]);
                MacAccessible acc = (MacAccessible)this.getAccessible(menuItemOwner);
                if (acc == null || (menu = (MacAccessible)acc.getContainerAccessible(AccessibleRole.CONTEXT_MENU)) == null) break;
                long ptr = menu.getNativeAccessible();
                MacAccessible.NSAccessibilityPostNotification(ptr, MacNotification.AXMenuClosed.ptr);
                MacAccessible.NSAccessibilityPostNotification(ptr, MacNotification.AXMenuOpened.ptr);
                break;
            }
            case TEXT: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.SPINNER) {
                    macNotification = MacNotification.NSAccessibilityTitleChangedNotification;
                    break;
                }
                macNotification = MacNotification.NSAccessibilityValueChangedNotification;
                break;
            }
            case PARENT: {
                this.ignoreInnerText = null;
                break;
            }
            default: {
                macNotification = MacNotification.NSAccessibilityValueChangedNotification;
            }
        }
        if (macNotification != null) {
            View view = this.getView();
            long id = view != null ? view.getNativeView() : this.peer;
            MacAccessible.NSAccessibilityPostNotification(id, macNotification.ptr);
        }
    }

    @Override
    protected long getNativeAccessible() {
        return this.peer;
    }

    private View getRootView(Scene scene) {
        if (scene == null) {
            return null;
        }
        Accessible acc = this.getAccessible(scene);
        if (acc == null || acc.isDisposed()) {
            return null;
        }
        View view = acc.getView();
        if (view == null || view.isClosed()) {
            return null;
        }
        return view;
    }

    private long[] getUnignoredChildren(ObservableList<Node> children) {
        if (children == null) {
            return new long[0];
        }
        long[] ids = children.stream().mapToLong(n -> this.getNativeAccessible((Node)n)).filter(n -> n != 0L).toArray();
        return MacAccessible.NSAccessibilityUnignoredChildren(ids);
    }

    private boolean isInMenu() {
        if (this.inMenu == null) {
            this.inMenu = this.getContainerAccessible(AccessibleRole.CONTEXT_MENU) != null || this.getContainerAccessible(AccessibleRole.MENU_BAR) != null;
        }
        return this.inMenu;
    }

    private boolean isMenuElement(AccessibleRole role) {
        if (role == null) {
            return false;
        }
        switch (role) {
            case MENU_BAR: 
            case CONTEXT_MENU: 
            case MENU_ITEM: 
            case RADIO_MENU_ITEM: 
            case CHECK_MENU_ITEM: 
            case MENU: {
                return true;
            }
        }
        return false;
    }

    private boolean isInSlider() {
        if (this.inSlider == null) {
            this.inSlider = this.getContainerAccessible(AccessibleRole.SLIDER) != null;
        }
        return this.inSlider;
    }

    private boolean ignoreInnerText() {
        if (this.ignoreInnerText != null) {
            return this.ignoreInnerText;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        this.ignoreInnerText = false;
        if (role == AccessibleRole.TEXT) {
            Node parent = (Node)this.getAttribute(AccessibleAttribute.PARENT, new Object[0]);
            if (parent == null) {
                return this.ignoreInnerText;
            }
            AccessibleRole parentRole = (AccessibleRole)((Object)this.getAccessible(parent).getAttribute(AccessibleAttribute.ROLE, new Object[0]));
            if (parentRole == null) {
                return this.ignoreInnerText;
            }
            switch (parentRole) {
                case BUTTON: 
                case TOGGLE_BUTTON: 
                case CHECK_BOX: 
                case RADIO_BUTTON: 
                case COMBO_BOX: 
                case TEXT: 
                case HYPERLINK: 
                case TAB_ITEM: {
                    this.ignoreInnerText = true;
                }
            }
        }
        return this.ignoreInnerText;
    }

    private int getMenuItemCmdGlyph(KeyCode code) {
        switch (code) {
            case ENTER: {
                return 4;
            }
            case SHIFT: {
                return 5;
            }
            case CONTROL: {
                return 6;
            }
            case META: {
                return 7;
            }
            case SPACE: {
                return 9;
            }
            case COMMAND: {
                return 17;
            }
            case ESCAPE: {
                return 27;
            }
            case CLEAR: {
                return 28;
            }
            case PAGE_UP: {
                return 98;
            }
            case CAPS: {
                return 99;
            }
            case LEFT: 
            case KP_LEFT: {
                return 100;
            }
            case RIGHT: 
            case KP_RIGHT: {
                return 101;
            }
            case HELP: {
                return 103;
            }
            case UP: 
            case KP_UP: {
                return 104;
            }
            case DOWN: 
            case KP_DOWN: {
                return 106;
            }
            case PAGE_DOWN: {
                return 107;
            }
            case CONTEXT_MENU: {
                return 109;
            }
            case POWER: {
                return 110;
            }
            case F1: {
                return 111;
            }
            case F2: {
                return 112;
            }
            case F3: {
                return 113;
            }
            case F4: {
                return 114;
            }
            case F5: {
                return 115;
            }
            case F6: {
                return 116;
            }
            case F7: {
                return 117;
            }
            case F8: {
                return 118;
            }
            case F9: {
                return 119;
            }
            case F10: {
                return 120;
            }
            case F11: {
                return 121;
            }
            case F12: {
                return 122;
            }
            case F13: {
                return 135;
            }
            case F14: {
                return 136;
            }
            case F15: {
                return 137;
            }
        }
        return 0;
    }

    private boolean isCmdCharBased(KeyCode code) {
        return code.isLetterKey() || code.isDigitKey() && !code.isKeypadKey();
    }

    private MacRole getRole(AccessibleRole role) {
        if (role == AccessibleRole.COMBO_BOX) {
            if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EDITABLE, new Object[0]))) {
                return MacRole.NSAccessibilityComboBoxRole;
            }
            return MacRole.NSAccessibilityPopUpButtonRole;
        }
        return MacRole.getRole(role);
    }

    private Bounds flipBounds(Bounds bounds) {
        View view = this.getRootView((Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]));
        if (view == null || view.getWindow() == null) {
            return null;
        }
        Screen screen = view.getWindow().getScreen();
        float height = screen.getHeight();
        return new BoundingBox(bounds.getMinX(), (double)height - bounds.getMinY() - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
    }

    private long[] accessibilityAttributeNames() {
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            MacSubrole macSubrole;
            ArrayList<MacAttribute> attrs = new ArrayList<MacAttribute>(baseAttributes);
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macAttributes != null) {
                attrs.addAll(macRole.macAttributes);
            }
            if ((macSubrole = MacSubrole.getRole(role)) != null && macSubrole.macAttributes != null) {
                attrs.addAll(macSubrole.macAttributes);
            }
            switch (role) {
                case LIST_VIEW: 
                case TREE_VIEW: {
                    attrs.remove((Object)MacAttribute.NSAccessibilitySelectedCellsAttribute);
                    break;
                }
                case MENU_BAR: 
                case CONTEXT_MENU: 
                case MENU_ITEM: 
                case RADIO_MENU_ITEM: 
                case CHECK_MENU_ITEM: 
                case MENU: {
                    attrs.remove((Object)MacAttribute.NSAccessibilityWindowAttribute);
                    attrs.remove((Object)MacAttribute.NSAccessibilityTopLevelUIElementAttribute);
                    break;
                }
                case COMBO_BOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    attrs.addAll(textAttributes);
                    break;
                }
            }
            return attrs.stream().mapToLong(a -> a.ptr).toArray();
        }
        return null;
    }

    private int accessibilityArrayAttributeCount(long attribute) {
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr == null) {
            return -1;
        }
        switch (attr) {
            case NSAccessibilityRowsAttribute: {
                AccessibleAttribute jfxAttr = this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.LIST_VIEW ? AccessibleAttribute.ITEM_COUNT : AccessibleAttribute.ROW_COUNT;
                Integer count = (Integer)this.getAttribute(jfxAttr, new Object[0]);
                return count != null ? count : 0;
            }
            case NSAccessibilityColumnsAttribute: {
                Integer count = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_COUNT, new Object[0]);
                return count != null ? count : 1;
            }
            case NSAccessibilityChildrenAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.MENU) {
                    ObservableList children = (ObservableList)this.getAttribute(AccessibleAttribute.CHILDREN, new Object[0]);
                    if (children == null) {
                        return 0;
                    }
                    long[] ids = this.getUnignoredChildren(children);
                    int count = ids.length;
                    if (this.getAttribute(AccessibleAttribute.SUBMENU, new Object[0]) != null) {
                        ++count;
                    }
                    return count;
                }
                return -1;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                Integer count = (Integer)this.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                return count != null ? count : 0;
            }
        }
        return -1;
    }

    private long[] accessibilityArrayAttributeValues(long attribute, int index, int maxCount) {
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr == null) {
            return null;
        }
        AccessibleAttribute jfxAttr = null;
        switch (attr) {
            case NSAccessibilityColumnsAttribute: {
                jfxAttr = AccessibleAttribute.COLUMN_AT_INDEX;
                break;
            }
            case NSAccessibilityRowsAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.LIST_VIEW) {
                    jfxAttr = AccessibleAttribute.ITEM_AT_INDEX;
                    break;
                }
                jfxAttr = AccessibleAttribute.ROW_AT_INDEX;
                break;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                jfxAttr = AccessibleAttribute.TREE_ITEM_AT_INDEX;
                break;
            }
            case NSAccessibilityChildrenAttribute: {
                Node menu;
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.MENU) break;
                long[] result = new long[maxCount];
                int i = 0;
                if (index == 0 && (menu = (Node)this.getAttribute(AccessibleAttribute.SUBMENU, new Object[0])) != null) {
                    result[i++] = this.getNativeAccessible(menu);
                }
                if (i < maxCount) {
                    ObservableList children = (ObservableList)this.getAttribute(AccessibleAttribute.CHILDREN, new Object[0]);
                    if (children == null) {
                        return null;
                    }
                    long[] ids = this.getUnignoredChildren(children);
                    --index;
                    while (i < maxCount && index < ids.length) {
                        result[i++] = ids[index++];
                    }
                }
                if (i < maxCount) {
                    result = Arrays.copyOf(result, i);
                }
                return result;
            }
        }
        if (jfxAttr != null) {
            Node node;
            int i;
            long[] result = new long[maxCount];
            for (i = 0; i < maxCount && (node = (Node)this.getAttribute(jfxAttr, index + i)) != null; ++i) {
                result[i] = this.getNativeAccessible(node);
            }
            if (i == maxCount) {
                return MacAccessible.NSAccessibilityUnignoredChildren(result);
            }
        }
        return null;
    }

    private boolean accessibilityIsAttributeSettable(long attribute) {
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr == null) {
            return false;
        }
        switch (attr) {
            case NSAccessibilityDisclosingAttribute: {
                Integer itemCount = (Integer)this.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                return itemCount != null && itemCount > 0;
            }
            case NSAccessibilityFocusedAttribute: 
            case NSAccessibilitySelectedAttribute: 
            case NSAccessibilitySelectedRowsAttribute: 
            case NSAccessibilitySelectedCellsAttribute: {
                return true;
            }
            case NSAccessibilityValueAttribute: 
            case NSAccessibilitySelectedTextRangeAttribute: {
                AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (role != AccessibleRole.TEXT_FIELD && role != AccessibleRole.TEXT_AREA || !Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EDITABLE, new Object[0]))) break;
                return true;
            }
        }
        return false;
    }

    private MacVariant accessibilityAttributeValue(long attribute) {
        MacRole macRole;
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr == null) {
            return null;
        }
        Function<Object, MacVariant> map = attr.map;
        AccessibleAttribute jfxAttr = attr.jfxAttr;
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return null;
        }
        if (jfxAttr == null) {
            block0 : switch (attr) {
                case NSAccessibilityValueAttribute: {
                    switch (role) {
                        case TAB_PANE: 
                        case PAGINATION: {
                            jfxAttr = AccessibleAttribute.FOCUS_ITEM;
                            map = MacVariant::createNSObject;
                            break block0;
                        }
                        case RADIO_BUTTON: 
                        case TAB_ITEM: 
                        case PAGE_ITEM: {
                            jfxAttr = AccessibleAttribute.SELECTED;
                            map = MacVariant::createNSNumberForBoolean;
                            break block0;
                        }
                        case SCROLL_BAR: 
                        case SLIDER: 
                        case PROGRESS_INDICATOR: 
                        case THUMB: {
                            jfxAttr = AccessibleAttribute.VALUE;
                            map = MacVariant::createNSNumberForDouble;
                            break block0;
                        }
                        case COMBO_BOX: 
                        case TEXT: 
                        case TEXT_FIELD: 
                        case TEXT_AREA: {
                            jfxAttr = AccessibleAttribute.TEXT;
                            map = MacVariant::createNSString;
                            break block0;
                        }
                        case TOGGLE_BUTTON: 
                        case CHECK_BOX: {
                            jfxAttr = AccessibleAttribute.SELECTED;
                            map = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                        case DATE_PICKER: {
                            jfxAttr = AccessibleAttribute.DATE;
                            map = MacVariant::createNSDate;
                            break block0;
                        }
                        case TITLED_PANE: {
                            jfxAttr = AccessibleAttribute.EXPANDED;
                            map = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                    }
                    return null;
                }
                case NSAccessibilitySelectedChildrenAttribute: {
                    AccessibleRole focusRole;
                    Scene scene;
                    Accessible acc;
                    Node focus = null;
                    if (role == AccessibleRole.CONTEXT_MENU && (acc = this.getAccessible(scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]))) != null) {
                        focus = (Node)acc.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                    }
                    if (role == AccessibleRole.MENU_BAR) {
                        focus = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                    }
                    if (focus != null && this.isMenuElement(focusRole = (AccessibleRole)((Object)this.getAccessible(focus).getAttribute(AccessibleAttribute.ROLE, new Object[0])))) {
                        long[] result = new long[]{this.getNativeAccessible(focus)};
                        return attr.map.apply(result);
                    }
                    return null;
                }
                case AXDateTimeComponents: {
                    if (this.getAttribute(AccessibleAttribute.DATE, new Object[0]) == null) {
                        return null;
                    }
                    return attr.map.apply(224);
                }
            }
        }
        if (jfxAttr == null) {
            return null;
        }
        Object result = this.getAttribute(jfxAttr, new Object[0]);
        if (result == null) {
            block14 : switch (attr) {
                case NSAccessibilityParentAttribute: {
                    break;
                }
                case NSAccessibilityColumnCountAttribute: {
                    result = 1;
                    break;
                }
                case NSAccessibilityColumnIndexRangeAttribute: {
                    if (role == AccessibleRole.TABLE_COLUMN && (result = this.getAttribute(AccessibleAttribute.INDEX, new Object[0])) != null) break;
                    return null;
                }
                case AXMenuItemCmdModifiers: {
                    return attr.map.apply(8);
                }
                case NSAccessibilityRoleDescriptionAttribute: {
                    switch (role) {
                        case TITLED_PANE: {
                            result = "title pane";
                            break block14;
                        }
                        case SPLIT_MENU_BUTTON: {
                            result = "split button";
                            break block14;
                        }
                        case PAGE_ITEM: {
                            result = "page";
                            break block14;
                        }
                        case TAB_ITEM: {
                            result = "tab";
                            break block14;
                        }
                        case LIST_VIEW: {
                            result = "list";
                            break block14;
                        }
                    }
                    macRole = this.getRole(role);
                    MacSubrole subRole = MacSubrole.getRole(role);
                    result = MacAccessible.NSAccessibilityRoleDescription(macRole.ptr, subRole != null ? subRole.ptr : 0L);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        block28 : switch (attr) {
            case NSAccessibilityWindowAttribute: 
            case NSAccessibilityTopLevelUIElementAttribute: {
                if (this.isMenuElement(role)) {
                    return null;
                }
                Scene scene = (Scene)result;
                View view = this.getRootView(scene);
                if (view == null || view.getWindow() == null) {
                    return null;
                }
                result = view.getWindow().getNativeWindow();
                break;
            }
            case NSAccessibilitySubroleAttribute: {
                MacSubrole subRole = MacSubrole.getRole((AccessibleRole)((Object)result));
                result = subRole != null ? subRole.ptr : 0L;
                break;
            }
            case NSAccessibilityRoleAttribute: {
                macRole = this.getRole(role);
                result = macRole != null ? macRole.ptr : 0L;
                break;
            }
            case NSAccessibilityEnabledAttribute: {
                result = Boolean.FALSE.equals(result);
                break;
            }
            case NSAccessibilityTabsAttribute: {
                Integer count = (Integer)result;
                long[] tabs = new long[count.intValue()];
                for (int i = 0; i < count; ++i) {
                    Node child = (Node)this.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, i);
                    tabs[i] = this.getNativeAccessible(child);
                }
                result = MacAccessible.NSAccessibilityUnignoredChildren(tabs);
                break;
            }
            case NSAccessibilityChildrenAttribute: 
            case NSAccessibilitySelectedRowsAttribute: 
            case NSAccessibilitySelectedCellsAttribute: 
            case NSAccessibilityVisibleChildrenAttribute: {
                ObservableList children = (ObservableList)result;
                result = this.getUnignoredChildren(children);
                break;
            }
            case NSAccessibilityParentAttribute: {
                if (this.getView() != null) {
                    if (this.getView().getWindow() == null) {
                        return null;
                    }
                    result = this.getView().getWindow().getNativeWindow();
                } else if (result != null) {
                    Node menuItem;
                    if (role == AccessibleRole.CONTEXT_MENU && (menuItem = (Node)this.getAttribute(AccessibleAttribute.PARENT_MENU, new Object[0])) != null && this.getAccessible(menuItem).getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.MENU) {
                        result = menuItem;
                    }
                    result = this.getNativeAccessible((Node)result);
                } else {
                    View view = this.getRootView((Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]));
                    if (view == null) {
                        return null;
                    }
                    result = view.getNativeView();
                }
                result = MacAccessible.NSAccessibilityUnignoredAncestor((Long)result);
                break;
            }
            case NSAccessibilityValueAttribute: {
                switch (role) {
                    case TAB_PANE: 
                    case PAGINATION: {
                        result = this.getNativeAccessible((Node)result);
                        break block28;
                    }
                    case TOGGLE_BUTTON: 
                    case CHECK_BOX: {
                        if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) {
                            result = 2;
                            break block28;
                        }
                        result = Boolean.TRUE.equals(result) ? 1 : 0;
                        break block28;
                    }
                    case TITLED_PANE: {
                        result = Boolean.TRUE.equals(result) ? 1 : 0;
                        break block28;
                    }
                }
                break;
            }
            case NSAccessibilityPositionAttribute: {
                result = this.flipBounds((Bounds)result);
                break;
            }
            case NSAccessibilityMaxValueAttribute: {
                if (!Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) break;
                return null;
            }
            case NSAccessibilityTitleAttribute: {
                switch (role) {
                    case COMBO_BOX: 
                    case TEXT: 
                    case TEXT_FIELD: 
                    case TEXT_AREA: {
                        return null;
                    }
                }
                break;
            }
            case AXMenuItemCmdChar: {
                KeyCode code;
                KeyCombination kc = (KeyCombination)result;
                result = null;
                if (kc instanceof KeyCharacterCombination) {
                    result = ((KeyCharacterCombination)kc).getCharacter();
                }
                if (kc instanceof KeyCodeCombination && this.isCmdCharBased(code = ((KeyCodeCombination)kc).getCode())) {
                    result = code.getName();
                }
                if (result != null) break;
                return null;
            }
            case AXMenuItemCmdVirtualKey: {
                KeyCode code;
                KeyCombination kc = (KeyCombination)result;
                result = null;
                if (kc instanceof KeyCodeCombination && !this.isCmdCharBased(code = ((KeyCodeCombination)kc).getCode())) {
                    int keyCode = code.impl_getCode();
                    result = MacApplication._getMacKey(keyCode);
                }
                if (result != null) break;
                return null;
            }
            case AXMenuItemCmdGlyph: {
                KeyCode code;
                KeyCombination kc = (KeyCombination)result;
                result = null;
                if (kc instanceof KeyCodeCombination && !this.isCmdCharBased(code = ((KeyCodeCombination)kc).getCode())) {
                    result = this.getMenuItemCmdGlyph(code);
                }
                if (result != null) break;
                return null;
            }
            case AXMenuItemCmdModifiers: {
                KeyCombination kc = (KeyCombination)result;
                int mod = 8;
                if (kc != null) {
                    if (kc.getShortcut() == KeyCombination.ModifierValue.DOWN) {
                        mod = 0;
                    }
                    if (kc.getAlt() == KeyCombination.ModifierValue.DOWN) {
                        mod |= 2;
                    }
                    if (kc.getControl() == KeyCombination.ModifierValue.DOWN) {
                        mod |= 4;
                    }
                    if (kc.getShift() == KeyCombination.ModifierValue.DOWN) {
                        mod |= 1;
                    }
                }
                result = mod;
                break;
            }
            case AXMenuItemMarkChar: {
                if (Boolean.TRUE.equals(result)) {
                    result = "\u2713";
                    break;
                }
                return null;
            }
            case NSAccessibilityNumberOfCharactersAttribute: {
                String text = (String)result;
                result = text.length();
                break;
            }
            case NSAccessibilitySelectedTextAttribute: {
                int start = (Integer)result;
                int end = -1;
                if (start != -1) {
                    result = this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                    if (result == null) {
                        return null;
                    }
                    end = (Integer)result;
                }
                if (start < 0 || end < 0 || start > end) {
                    return null;
                }
                String string = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                if (string == null) {
                    return null;
                }
                if (end > string.length()) {
                    return null;
                }
                result = string.substring(start, end);
                break;
            }
            case NSAccessibilitySelectedTextRangeAttribute: {
                int start = (Integer)result;
                int end = -1;
                if (start != -1) {
                    result = this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                    if (result == null) {
                        return null;
                    }
                    end = (Integer)result;
                }
                if (start < 0 || end < 0 || start > end) {
                    return null;
                }
                String string = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                if (string == null) {
                    return null;
                }
                if (end > string.length()) {
                    return null;
                }
                result = new int[]{start, end - start};
                break;
            }
            case NSAccessibilityInsertionPointLineNumberAttribute: {
                if (role == AccessibleRole.TEXT_AREA) {
                    Integer lineIndex = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, result);
                    result = lineIndex != null ? lineIndex : 0;
                    break;
                }
                result = 0;
                break;
            }
            case NSAccessibilityVisibleCharacterRangeAttribute: {
                String string = (String)result;
                result = new int[]{0, string.length()};
                break;
            }
            case NSAccessibilityContentsAttribute: {
                if (result == null) break;
                result = new long[]{this.getNativeAccessible((Node)result)};
                break;
            }
            case NSAccessibilityColumnIndexRangeAttribute: 
            case NSAccessibilityRowIndexRangeAttribute: {
                Integer location = (Integer)result;
                result = new int[]{location, 1};
                break;
            }
            case NSAccessibilityDisclosedByRowAttribute: 
            case NSAccessibilityOverflowButtonAttribute: 
            case NSAccessibilityTitleUIElementAttribute: 
            case NSAccessibilityHeaderAttribute: 
            case NSAccessibilityHorizontalScrollBarAttribute: 
            case NSAccessibilityVerticalScrollBarAttribute: {
                result = this.getNativeAccessible((Node)result);
                break;
            }
            case NSAccessibilityOrientationAttribute: {
                Orientation orientation = (Orientation)((Object)result);
                switch (orientation) {
                    case HORIZONTAL: {
                        result = MacOrientation.NSAccessibilityHorizontalOrientationValue.ptr;
                        break block28;
                    }
                    case VERTICAL: {
                        result = MacOrientation.NSAccessibilityVerticalOrientationValue.ptr;
                        break block28;
                    }
                }
                return null;
            }
            case NSAccessibilityDisclosingAttribute: {
                if (result != Boolean.TRUE || !Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.LEAF, new Object[0]))) break;
                result = Boolean.FALSE;
                break;
            }
        }
        return result != null ? map.apply(result) : null;
    }

    private void accessibilitySetValue(long value, long attribute) {
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr != null) {
            switch (attr) {
                case NSAccessibilityFocusedAttribute: {
                    MacVariant variant = MacAccessible.idToMacVariant(value, 9);
                    if (variant == null || variant.int1 == 0) break;
                    this.executeAction(AccessibleAction.REQUEST_FOCUS, new Object[0]);
                    break;
                }
                case NSAccessibilityDisclosingAttribute: {
                    MacVariant variant = MacAccessible.idToMacVariant(value, 9);
                    if (variant == null) break;
                    if (variant.int1 != 0) {
                        this.executeAction(AccessibleAction.EXPAND, new Object[0]);
                        break;
                    }
                    this.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
                    break;
                }
                case NSAccessibilityExpandedAttribute: {
                    if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.COMBO_BOX) break;
                    this.executeAction(AccessibleAction.EXPAND, new Object[0]);
                    break;
                }
                case NSAccessibilitySelectedCellsAttribute: {
                    MacVariant variant = MacAccessible.idToMacVariant(value, 1);
                    if (variant == null || variant.longArray == null || variant.longArray.length <= 0) break;
                    long[] ids = variant.longArray;
                    ObservableList<Node> items = FXCollections.observableArrayList();
                    for (long id : ids) {
                        Node cell;
                        MacAccessible acc = MacAccessible.GlassAccessibleToMacAccessible(id);
                        if (acc == null) continue;
                        Integer rowIndex = (Integer)acc.getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
                        Integer columnIndex = (Integer)acc.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
                        if (rowIndex == null || columnIndex == null || (cell = (Node)this.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, rowIndex, columnIndex)) == null) continue;
                        items.add(cell);
                    }
                    this.executeAction(AccessibleAction.SET_SELECTED_ITEMS, items);
                    break;
                }
                case NSAccessibilitySelectedRowsAttribute: {
                    MacVariant variant = MacAccessible.idToMacVariant(value, 1);
                    if (variant == null || variant.longArray == null || variant.longArray.length <= 0) break;
                    long[] ids = variant.longArray;
                    ObservableList<Node> items = FXCollections.observableArrayList();
                    for (long id : ids) {
                        Node cell;
                        Integer index;
                        MacAccessible acc = MacAccessible.GlassAccessibleToMacAccessible(id);
                        if (acc == null || (index = (Integer)acc.getAttribute(AccessibleAttribute.INDEX, new Object[0])) == null || (cell = (Node)this.getAttribute(AccessibleAttribute.ROW_AT_INDEX, index)) == null) continue;
                        items.add(cell);
                    }
                    this.executeAction(AccessibleAction.SET_SELECTED_ITEMS, items);
                    break;
                }
                case NSAccessibilitySelectedTextRangeAttribute: {
                    MacVariant variant = MacAccessible.idToMacVariant(value, 18);
                    if (variant == null) break;
                    int start = variant.int1;
                    int end = variant.int1 + variant.int2;
                    this.executeAction(AccessibleAction.SET_TEXT_SELECTION, start, end);
                    break;
                }
            }
        }
    }

    private long accessibilityIndexOfChild(long child) {
        return -1L;
    }

    private long[] accessibilityParameterizedAttributeNames() {
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            ArrayList<MacAttribute> attrs = new ArrayList<MacAttribute>();
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macParameterizedAttributes != null) {
                attrs.addAll(macRole.macParameterizedAttributes);
            }
            switch (role) {
                case LIST_VIEW: 
                case TREE_VIEW: {
                    attrs.remove((Object)MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
                    break;
                }
                case COMBO_BOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    attrs.addAll(textParameterizedAttributes);
                    break;
                }
            }
            return attrs.stream().mapToLong(a -> a.ptr).toArray();
        }
        return null;
    }

    private MacVariant accessibilityAttributeValueForParameter(long attribute, long parameter) {
        String text;
        Object result;
        MacAttribute attr = MacAttribute.getAttribute(attribute);
        if (attr == null || attr.inputType == 0 || attr.jfxAttr == null) {
            return null;
        }
        MacVariant variant = MacAccessible.idToMacVariant(parameter, attr.inputType);
        if (variant == null) {
            return null;
        }
        Object value = variant.getValue();
        switch (attr) {
            case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                int[] intArray = (int[])value;
                result = this.getAttribute(attr.jfxAttr, intArray[1], intArray[0]);
                break;
            }
            case NSAccessibilityLineForIndexParameterizedAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.TEXT_AREA) {
                    result = this.getAttribute(attr.jfxAttr, value);
                    break;
                }
                result = 0;
                break;
            }
            case NSAccessibilityRangeForLineParameterizedAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.TEXT_AREA) {
                    Integer lineStart = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, value);
                    Integer lineEnd = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, value);
                    if (lineStart != null && lineEnd != null) {
                        result = new int[]{lineStart, lineEnd - lineStart};
                        break;
                    }
                    result = null;
                    break;
                }
                text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                result = new int[]{0, text != null ? text.length() : 0};
                break;
            }
            case NSAccessibilityBoundsForRangeParameterizedAttribute: {
                int[] intArray = (int[])value;
                Bounds[] bounds = (Bounds[])this.getAttribute(attr.jfxAttr, intArray[0], intArray[0] + intArray[1] - 1);
                double left = Double.POSITIVE_INFINITY;
                double top = Double.POSITIVE_INFINITY;
                double right = Double.NEGATIVE_INFINITY;
                double bottom = Double.NEGATIVE_INFINITY;
                if (bounds != null) {
                    for (int i = 0; i < bounds.length; ++i) {
                        Bounds b = bounds[i];
                        if (b == null) continue;
                        if (b.getMinX() < left) {
                            left = b.getMinX();
                        }
                        if (b.getMinY() < top) {
                            top = b.getMinY();
                        }
                        if (b.getMaxX() > right) {
                            right = b.getMaxX();
                        }
                        if (!(b.getMaxY() > bottom)) continue;
                        bottom = b.getMaxY();
                    }
                }
                result = this.flipBounds(new BoundingBox(left, top, right - left, bottom - top));
                break;
            }
            case NSAccessibilityRangeForPositionParameterizedAttribute: {
                float[] floatArray = (float[])value;
                Integer offset = (Integer)this.getAttribute(attr.jfxAttr, new Point2D(floatArray[0], floatArray[1]));
                if (offset != null) {
                    result = new int[]{offset, 1};
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = this.getAttribute(attr.jfxAttr, value);
            }
        }
        if (result == null) {
            return null;
        }
        switch (attr) {
            case NSAccessibilityAttributedStringForRangeParameterizedAttribute: {
                text = (String)result;
                text = text.substring(variant.int1, variant.int1 + variant.int2);
                ArrayList<MacVariant> styles = new ArrayList<MacVariant>();
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font != null) {
                    MacVariant fontDict = new MacVariant();
                    fontDict.type = 8;
                    fontDict.longArray = new long[]{MacText.NSAccessibilityFontNameKey.ptr, MacText.NSAccessibilityFontFamilyKey.ptr, MacText.NSAccessibilityVisibleNameKey.ptr, MacText.NSAccessibilityFontSizeKey.ptr};
                    fontDict.variantArray = new MacVariant[]{MacVariant.createNSString(font.getName()), MacVariant.createNSString(font.getFamily()), MacVariant.createNSString(font.getName()), MacVariant.createNSNumberForDouble(font.getSize())};
                    fontDict.key = MacText.NSAccessibilityFontTextAttribute.ptr;
                    fontDict.location = 0;
                    fontDict.length = text.length();
                    styles.add(fontDict);
                }
                MacVariant attrString = attr.map.apply(text);
                attrString.variantArray = styles.toArray(new MacVariant[0]);
                return attrString;
            }
            case NSAccessibilityStringForRangeParameterizedAttribute: {
                text = (String)result;
                result = text.substring(variant.int1, variant.int1 + variant.int2);
                break;
            }
            case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                result = this.getNativeAccessible((Node)result);
                break;
            }
        }
        return attr.map.apply(result);
    }

    private long[] accessibilityActionNames() {
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        ArrayList<MacAction> actions = new ArrayList<MacAction>();
        if (role != null) {
            MacRole macRole = this.getRole(role);
            if (macRole != null && macRole.macActions != null) {
                actions.addAll(macRole.macActions);
            }
            if (role != AccessibleRole.NODE && role != AccessibleRole.PARENT) {
                actions.add(MacAction.NSAccessibilityShowMenuAction);
            }
        }
        return actions.stream().mapToLong(a -> a.ptr).toArray();
    }

    private String accessibilityActionDescription(long action) {
        return MacAccessible.NSAccessibilityActionDescription(action);
    }

    private void accessibilityPerformAction(long action) {
        AccessibleRole role;
        MacAction macAction = MacAction.getAction(action);
        boolean expand = false;
        if (macAction == MacAction.NSAccessibilityPressAction && ((role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]))) == AccessibleRole.TITLED_PANE || role == AccessibleRole.COMBO_BOX)) {
            expand = true;
        }
        if (macAction == MacAction.NSAccessibilityShowMenuAction && this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.SPLIT_MENU_BUTTON) {
            expand = true;
        }
        if (expand) {
            if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]))) {
                this.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
            } else {
                this.executeAction(AccessibleAction.EXPAND, new Object[0]);
            }
            return;
        }
        if (macAction != null && macAction.jfxAction != null) {
            this.executeAction(macAction.jfxAction, new Object[0]);
        }
    }

    private long accessibilityFocusedUIElement() {
        Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
        if (node == null) {
            return 0L;
        }
        Node item = (Node)this.getAccessible(node).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
        if (item != null) {
            return this.getNativeAccessible(item);
        }
        return this.getNativeAccessible(node);
    }

    private boolean accessibilityIsIgnored() {
        if (this.isIgnored()) {
            return true;
        }
        if (this.isInSlider()) {
            return true;
        }
        if (this.isInMenu()) {
            AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
            return !this.isMenuElement(role);
        }
        return this.ignoreInnerText();
    }

    private long accessibilityHitTest(float x, float y) {
        View view = this.getView();
        if (view == null || view.getWindow() == null) {
            return 0L;
        }
        Screen screen = view.getWindow().getScreen();
        y = (float)screen.getHeight() - y;
        Node node = (Node)this.getAttribute(AccessibleAttribute.NODE_AT_POINT, new Point2D(x, y));
        return MacAccessible.NSAccessibilityUnignoredAncestor(this.getNativeAccessible(node));
    }

    static {
        MacAccessible._initIDs();
        if (!MacAccessible._initEnum("MacAttribute")) {
            System.err.println("Fail linking MacAttribute");
        }
        if (!MacAccessible._initEnum("MacAction")) {
            System.err.println("Fail linking MacAction");
        }
        if (!MacAccessible._initEnum("MacRole")) {
            System.err.println("Fail linking MacRole");
        }
        if (!MacAccessible._initEnum("MacSubrole")) {
            System.err.println("Fail linking MacSubrole");
        }
        if (!MacAccessible._initEnum("MacNotification")) {
            System.err.println("Fail linking MacNotification");
        }
        if (!MacAccessible._initEnum("MacOrientation")) {
            System.err.println("Fail linking MacOrientation");
        }
        if (!MacAccessible._initEnum("MacText")) {
            System.err.println("Fail linking MacText");
        }
        baseAttributes = Arrays.asList(MacAttribute.NSAccessibilityRoleAttribute, MacAttribute.NSAccessibilityRoleDescriptionAttribute, MacAttribute.NSAccessibilityHelpAttribute, MacAttribute.NSAccessibilityFocusedAttribute, MacAttribute.NSAccessibilityParentAttribute, MacAttribute.NSAccessibilityChildrenAttribute, MacAttribute.NSAccessibilityPositionAttribute, MacAttribute.NSAccessibilitySizeAttribute, MacAttribute.NSAccessibilityWindowAttribute, MacAttribute.NSAccessibilityTopLevelUIElementAttribute, MacAttribute.NSAccessibilityTitleUIElementAttribute);
        textAttributes = Arrays.asList(MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityNumberOfCharactersAttribute, MacAttribute.NSAccessibilitySelectedTextAttribute, MacAttribute.NSAccessibilitySelectedTextRangeAttribute, MacAttribute.NSAccessibilityInsertionPointLineNumberAttribute, MacAttribute.NSAccessibilityVisibleCharacterRangeAttribute);
        textParameterizedAttributes = Arrays.asList(MacAttribute.NSAccessibilityLineForIndexParameterizedAttribute, MacAttribute.NSAccessibilityRangeForLineParameterizedAttribute, MacAttribute.NSAccessibilityAttributedStringForRangeParameterizedAttribute, MacAttribute.NSAccessibilityStringForRangeParameterizedAttribute);
    }

    private static enum MacText {
        NSAccessibilityBackgroundColorTextAttribute,
        NSAccessibilityForegroundColorTextAttribute,
        NSAccessibilityUnderlineTextAttribute,
        NSAccessibilityStrikethroughTextAttribute,
        NSAccessibilityMarkedMisspelledTextAttribute,
        NSAccessibilityFontTextAttribute,
        NSAccessibilityFontNameKey,
        NSAccessibilityFontFamilyKey,
        NSAccessibilityVisibleNameKey,
        NSAccessibilityFontSizeKey;

        long ptr;
    }

    private static enum MacOrientation {
        NSAccessibilityHorizontalOrientationValue,
        NSAccessibilityVerticalOrientationValue,
        NSAccessibilityUnknownOrientationValue;

        long ptr;
    }

    private static enum MacNotification {
        NSAccessibilityCreatedNotification,
        NSAccessibilityFocusedUIElementChangedNotification,
        NSAccessibilityValueChangedNotification,
        NSAccessibilitySelectedChildrenChangedNotification,
        NSAccessibilitySelectedRowsChangedNotification,
        NSAccessibilityTitleChangedNotification,
        NSAccessibilityRowCountChangedNotification,
        NSAccessibilitySelectedCellsChangedNotification,
        NSAccessibilityUIElementDestroyedNotification,
        NSAccessibilitySelectedTextChangedNotification,
        NSAccessibilityRowExpandedNotification,
        NSAccessibilityRowCollapsedNotification,
        AXMenuOpened,
        AXMenuClosed;

        long ptr;
    }

    private static enum MacAction {
        NSAccessibilityCancelAction,
        NSAccessibilityConfirmAction,
        NSAccessibilityDecrementAction(AccessibleAction.DECREMENT),
        NSAccessibilityDeleteAction,
        NSAccessibilityIncrementAction(AccessibleAction.INCREMENT),
        NSAccessibilityPickAction,
        NSAccessibilityPressAction(AccessibleAction.FIRE),
        NSAccessibilityRaiseAction,
        NSAccessibilityShowMenuAction(AccessibleAction.SHOW_MENU);

        long ptr;
        AccessibleAction jfxAction;

        private MacAction() {
        }

        private MacAction(AccessibleAction jfxAction) {
            this.jfxAction = jfxAction;
        }

        static MacAction getAction(long ptr) {
            for (MacAction macAction : MacAction.values()) {
                if (macAction.ptr != ptr && !MacAccessible.isEqualToString(macAction.ptr, ptr)) continue;
                return macAction;
            }
            return null;
        }
    }

    private static enum MacSubrole {
        NSAccessibilityTableRowSubrole(AccessibleRole.LIST_ITEM, AccessibleRole.TABLE_ROW),
        NSAccessibilitySecureTextFieldSubrole(AccessibleRole.PASSWORD_FIELD),
        NSAccessibilityOutlineRowSubrole(new AccessibleRole[]{AccessibleRole.TREE_ITEM, AccessibleRole.TREE_TABLE_ROW}, new MacAttribute[]{MacAttribute.NSAccessibilityDisclosedByRowAttribute, MacAttribute.NSAccessibilityDisclosedRowsAttribute, MacAttribute.NSAccessibilityDisclosingAttribute, MacAttribute.NSAccessibilityDisclosureLevelAttribute}),
        NSAccessibilityDecrementArrowSubrole(new AccessibleRole[]{AccessibleRole.DECREMENT_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute}),
        NSAccessibilityIncrementArrowSubrole(new AccessibleRole[]{AccessibleRole.INCREMENT_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute});

        long ptr;
        AccessibleRole[] jfxRoles;
        List<MacAttribute> macAttributes;

        private MacSubrole(AccessibleRole ... jfxRoles) {
            this(jfxRoles, (MacAttribute[])null);
        }

        private MacSubrole(AccessibleRole[] jfxRoles, MacAttribute[] macAttributes) {
            this.jfxRoles = jfxRoles;
            this.macAttributes = macAttributes != null ? Arrays.asList(macAttributes) : null;
        }

        static MacSubrole getRole(AccessibleRole targetRole) {
            if (targetRole == null) {
                return null;
            }
            for (MacSubrole macRole : MacSubrole.values()) {
                for (AccessibleRole jfxRole : macRole.jfxRoles) {
                    if (jfxRole != targetRole) continue;
                    return macRole;
                }
            }
            return null;
        }
    }

    private static enum MacRole {
        NSAccessibilityUnknownRole(AccessibleRole.NODE, null, null),
        NSAccessibilityGroupRole(AccessibleRole.PARENT, null, null),
        NSAccessibilityButtonRole(new AccessibleRole[]{AccessibleRole.BUTTON, AccessibleRole.INCREMENT_BUTTON, AccessibleRole.DECREMENT_BUTTON, AccessibleRole.SPLIT_MENU_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityIncrementorRole(AccessibleRole.SPINNER, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute}, new MacAction[]{MacAction.NSAccessibilityIncrementAction, MacAction.NSAccessibilityDecrementAction}),
        AXJFXTOOLTIP(AccessibleRole.TOOLTIP, null, null),
        NSAccessibilityImageRole(AccessibleRole.IMAGE_VIEW, null, null),
        NSAccessibilityRadioButtonRole(new AccessibleRole[]{AccessibleRole.RADIO_BUTTON, AccessibleRole.TAB_ITEM, AccessibleRole.PAGE_ITEM}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityCheckBoxRole(new AccessibleRole[]{AccessibleRole.CHECK_BOX, AccessibleRole.TOGGLE_BUTTON}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}, null),
        NSAccessibilityComboBoxRole(AccessibleRole.COMBO_BOX, new MacAttribute[]{MacAttribute.NSAccessibilityExpandedAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityPopUpButtonRole(AccessibleRole.COMBO_BOX, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityTabGroupRole(new AccessibleRole[]{AccessibleRole.TAB_PANE, AccessibleRole.PAGINATION}, new MacAttribute[]{MacAttribute.NSAccessibilityTabsAttribute, MacAttribute.NSAccessibilityValueAttribute}, null, null),
        NSAccessibilityProgressIndicatorRole(AccessibleRole.PROGRESS_INDICATOR, new MacAttribute[]{MacAttribute.NSAccessibilityOrientationAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute}, null),
        NSAccessibilityMenuBarRole(AccessibleRole.MENU_BAR, new MacAttribute[]{MacAttribute.NSAccessibilitySelectedChildrenAttribute, MacAttribute.NSAccessibilityEnabledAttribute}, new MacAction[]{MacAction.NSAccessibilityCancelAction}),
        NSAccessibilityMenuRole(AccessibleRole.CONTEXT_MENU, new MacAttribute[]{MacAttribute.NSAccessibilitySelectedChildrenAttribute, MacAttribute.NSAccessibilityEnabledAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction, MacAction.NSAccessibilityCancelAction}),
        NSAccessibilityMenuItemRole(new AccessibleRole[]{AccessibleRole.MENU_ITEM, AccessibleRole.RADIO_MENU_ITEM, AccessibleRole.CHECK_MENU_ITEM, AccessibleRole.MENU}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute, MacAttribute.NSAccessibilitySelectedAttribute, MacAttribute.AXMenuItemCmdChar, MacAttribute.AXMenuItemCmdVirtualKey, MacAttribute.AXMenuItemCmdGlyph, MacAttribute.AXMenuItemCmdModifiers, MacAttribute.AXMenuItemMarkChar}, new MacAction[]{MacAction.NSAccessibilityPressAction, MacAction.NSAccessibilityCancelAction}, null),
        NSAccessibilityMenuButtonRole(AccessibleRole.MENU_BUTTON, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityTitleAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityStaticTextRole(new AccessibleRole[]{AccessibleRole.TEXT}, null, null, null),
        NSAccessibilityTextFieldRole(new AccessibleRole[]{AccessibleRole.TEXT_FIELD, AccessibleRole.PASSWORD_FIELD}, null, null, null),
        NSAccessibilityTextAreaRole(AccessibleRole.TEXT_AREA, null, null),
        NSAccessibilitySliderRole(AccessibleRole.SLIDER, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOrientationAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute}, new MacAction[]{MacAction.NSAccessibilityDecrementAction, MacAction.NSAccessibilityIncrementAction}),
        NSAccessibilityScrollAreaRole(AccessibleRole.SCROLL_PANE, new MacAttribute[]{MacAttribute.NSAccessibilityContentsAttribute, MacAttribute.NSAccessibilityHorizontalScrollBarAttribute, MacAttribute.NSAccessibilityVerticalScrollBarAttribute}, null),
        NSAccessibilityScrollBarRole(AccessibleRole.SCROLL_BAR, new MacAttribute[]{MacAttribute.NSAccessibilityValueAttribute, MacAttribute.NSAccessibilityMinValueAttribute, MacAttribute.NSAccessibilityMaxValueAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOrientationAttribute}, null),
        NSAccessibilityValueIndicatorRole(AccessibleRole.THUMB, new MacAttribute[]{MacAttribute.NSAccessibilityValueAttribute}, null),
        NSAccessibilityRowRole(new AccessibleRole[]{AccessibleRole.LIST_ITEM, AccessibleRole.TABLE_ROW, AccessibleRole.TREE_ITEM, AccessibleRole.TREE_TABLE_ROW}, new MacAttribute[]{MacAttribute.NSAccessibilitySubroleAttribute, MacAttribute.NSAccessibilityIndexAttribute, MacAttribute.NSAccessibilitySelectedAttribute, MacAttribute.NSAccessibilityVisibleChildrenAttribute}, null, null),
        NSAccessibilityTableRole(new AccessibleRole[]{AccessibleRole.LIST_VIEW, AccessibleRole.TABLE_VIEW}, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityColumnsAttribute, MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedRowsAttribute, MacAttribute.NSAccessibilityRowCountAttribute, MacAttribute.NSAccessibilityColumnCountAttribute, MacAttribute.NSAccessibilitySelectedCellsAttribute}, null, new MacAttribute[]{MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute}),
        NSAccessibilityColumnRole(AccessibleRole.TABLE_COLUMN, new MacAttribute[]{MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityIndexAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedAttribute}, null),
        NSAccessibilityCellRole(new AccessibleRole[]{AccessibleRole.TABLE_CELL, AccessibleRole.TREE_TABLE_CELL}, new MacAttribute[]{MacAttribute.NSAccessibilityColumnIndexRangeAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityRowIndexRangeAttribute, MacAttribute.NSAccessibilitySelectedAttribute}, null, null),
        NSAccessibilityLinkRole(AccessibleRole.HYPERLINK, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.AXVisited}, null),
        NSAccessibilityOutlineRole(new AccessibleRole[]{AccessibleRole.TREE_VIEW, AccessibleRole.TREE_TABLE_VIEW}, new MacAttribute[]{MacAttribute.NSAccessibilityColumnsAttribute, MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityHeaderAttribute, MacAttribute.NSAccessibilityRowsAttribute, MacAttribute.NSAccessibilitySelectedRowsAttribute, MacAttribute.NSAccessibilitySelectedCellsAttribute}, null, new MacAttribute[]{MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute}),
        NSAccessibilityDisclosureTriangleRole(AccessibleRole.TITLED_PANE, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute}, new MacAction[]{MacAction.NSAccessibilityPressAction}),
        NSAccessibilityToolbarRole(AccessibleRole.TOOL_BAR, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityOverflowButtonAttribute}, null),
        AXDateTimeArea(AccessibleRole.DATE_PICKER, new MacAttribute[]{MacAttribute.NSAccessibilityEnabledAttribute, MacAttribute.NSAccessibilityValueAttribute, MacAttribute.AXDateTimeComponents}, null);

        long ptr;
        AccessibleRole[] jfxRoles;
        List<MacAttribute> macAttributes;
        List<MacAttribute> macParameterizedAttributes;
        List<MacAction> macActions;

        private MacRole(AccessibleRole jfxRole, MacAttribute[] macAttributes, MacAction[] macActions) {
            this(new AccessibleRole[]{jfxRole}, macAttributes, macActions, null);
        }

        private MacRole(AccessibleRole[] jfxRoles, MacAttribute[] macAttributes, MacAction[] macActions, MacAttribute[] macParameterizedAttributes) {
            this.jfxRoles = jfxRoles;
            this.macAttributes = macAttributes != null ? Arrays.asList(macAttributes) : null;
            this.macActions = macActions != null ? Arrays.asList(macActions) : null;
            this.macParameterizedAttributes = macParameterizedAttributes != null ? Arrays.asList(macParameterizedAttributes) : null;
        }

        static MacRole getRole(AccessibleRole targetRole) {
            if (targetRole == null) {
                return null;
            }
            for (MacRole macRole : MacRole.values()) {
                for (AccessibleRole jfxRole : macRole.jfxRoles) {
                    if (jfxRole != targetRole) continue;
                    return macRole;
                }
            }
            return null;
        }
    }

    private static enum MacAttribute {
        NSAccessibilityValueAttribute(null, null),
        NSAccessibilityChildrenAttribute(AccessibleAttribute.CHILDREN, MacVariant::createNSArray),
        NSAccessibilityEnabledAttribute(AccessibleAttribute.DISABLED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityHelpAttribute(AccessibleAttribute.HELP, MacVariant::createNSString),
        NSAccessibilityFocusedAttribute(AccessibleAttribute.FOCUSED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityExpandedAttribute(AccessibleAttribute.EXPANDED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityMaxValueAttribute(AccessibleAttribute.MAX_VALUE, MacVariant::createNSNumberForDouble),
        NSAccessibilityMinValueAttribute(AccessibleAttribute.MIN_VALUE, MacVariant::createNSNumberForDouble),
        NSAccessibilityParentAttribute(AccessibleAttribute.PARENT, MacVariant::createNSObject),
        NSAccessibilityPositionAttribute(AccessibleAttribute.BOUNDS, MacVariant::createNSValueForPoint),
        NSAccessibilityRoleAttribute(AccessibleAttribute.ROLE, MacVariant::createNSObject),
        NSAccessibilitySubroleAttribute(AccessibleAttribute.ROLE, MacVariant::createNSObject),
        NSAccessibilityRoleDescriptionAttribute(AccessibleAttribute.ROLE_DESCRIPTION, MacVariant::createNSString),
        NSAccessibilitySizeAttribute(AccessibleAttribute.BOUNDS, MacVariant::createNSValueForSize),
        NSAccessibilityTabsAttribute(AccessibleAttribute.ITEM_COUNT, MacVariant::createNSArray),
        NSAccessibilityTitleAttribute(AccessibleAttribute.TEXT, MacVariant::createNSString),
        NSAccessibilityTopLevelUIElementAttribute(AccessibleAttribute.SCENE, MacVariant::createNSObject),
        NSAccessibilityWindowAttribute(AccessibleAttribute.SCENE, MacVariant::createNSObject),
        NSAccessibilityTitleUIElementAttribute(AccessibleAttribute.LABELED_BY, MacVariant::createNSObject),
        NSAccessibilityOrientationAttribute(AccessibleAttribute.ORIENTATION, MacVariant::createNSObject),
        NSAccessibilityOverflowButtonAttribute(AccessibleAttribute.OVERFLOW_BUTTON, MacVariant::createNSObject),
        AXVisited(AccessibleAttribute.VISITED, MacVariant::createNSNumberForBoolean),
        AXMenuItemCmdChar(AccessibleAttribute.ACCELERATOR, MacVariant::createNSString),
        AXMenuItemCmdVirtualKey(AccessibleAttribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemCmdGlyph(AccessibleAttribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemCmdModifiers(AccessibleAttribute.ACCELERATOR, MacVariant::createNSNumberForInt),
        AXMenuItemMarkChar(AccessibleAttribute.SELECTED, MacVariant::createNSString),
        AXDateTimeComponents(null, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedChildrenAttribute(null, MacVariant::createNSArray),
        NSAccessibilityNumberOfCharactersAttribute(AccessibleAttribute.TEXT, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedTextAttribute(AccessibleAttribute.SELECTION_START, MacVariant::createNSString),
        NSAccessibilitySelectedTextRangeAttribute(AccessibleAttribute.SELECTION_START, MacVariant::createNSValueForRange),
        NSAccessibilitySelectedTextRangesAttribute(null, null),
        NSAccessibilityInsertionPointLineNumberAttribute(AccessibleAttribute.CARET_OFFSET, MacVariant::createNSNumberForInt),
        NSAccessibilityVisibleCharacterRangeAttribute(AccessibleAttribute.TEXT, MacVariant::createNSValueForRange),
        NSAccessibilityContentsAttribute(AccessibleAttribute.CONTENTS, MacVariant::createNSArray),
        NSAccessibilityHorizontalScrollBarAttribute(AccessibleAttribute.HORIZONTAL_SCROLLBAR, MacVariant::createNSObject),
        NSAccessibilityVerticalScrollBarAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, MacVariant::createNSObject),
        NSAccessibilityIndexAttribute(AccessibleAttribute.INDEX, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedAttribute(AccessibleAttribute.SELECTED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityVisibleChildrenAttribute(AccessibleAttribute.CHILDREN, MacVariant::createNSArray),
        NSAccessibilityDisclosedByRowAttribute(AccessibleAttribute.TREE_ITEM_PARENT, MacVariant::createNSObject),
        NSAccessibilityDisclosedRowsAttribute(null, null),
        NSAccessibilityDisclosingAttribute(AccessibleAttribute.EXPANDED, MacVariant::createNSNumberForBoolean),
        NSAccessibilityDisclosureLevelAttribute(AccessibleAttribute.DISCLOSURE_LEVEL, MacVariant::createNSNumberForInt),
        NSAccessibilityColumnsAttribute(null, null),
        NSAccessibilityRowsAttribute(null, null),
        NSAccessibilityHeaderAttribute(AccessibleAttribute.HEADER, MacVariant::createNSObject),
        NSAccessibilitySelectedRowsAttribute(AccessibleAttribute.SELECTED_ITEMS, MacVariant::createNSArray),
        NSAccessibilityRowCountAttribute(AccessibleAttribute.ROW_COUNT, MacVariant::createNSNumberForInt),
        NSAccessibilityColumnCountAttribute(AccessibleAttribute.COLUMN_COUNT, MacVariant::createNSNumberForInt),
        NSAccessibilitySelectedCellsAttribute(AccessibleAttribute.SELECTED_ITEMS, MacVariant::createNSArray),
        NSAccessibilityRowIndexRangeAttribute(AccessibleAttribute.ROW_INDEX, MacVariant::createNSValueForRange),
        NSAccessibilityColumnIndexRangeAttribute(AccessibleAttribute.COLUMN_INDEX, MacVariant::createNSValueForRange),
        NSAccessibilityLineForIndexParameterizedAttribute(AccessibleAttribute.LINE_FOR_OFFSET, MacVariant::createNSNumberForInt, 10),
        NSAccessibilityStringForRangeParameterizedAttribute(AccessibleAttribute.TEXT, MacVariant::createNSString, 18),
        NSAccessibilityRangeForLineParameterizedAttribute(AccessibleAttribute.LINE_START, MacVariant::createNSValueForRange, 10),
        NSAccessibilityAttributedStringForRangeParameterizedAttribute(AccessibleAttribute.TEXT, MacVariant::createNSAttributedString, 18),
        NSAccessibilityCellForColumnAndRowParameterizedAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, MacVariant::createNSObject, 3),
        NSAccessibilityRangeForPositionParameterizedAttribute(AccessibleAttribute.OFFSET_AT_POINT, MacVariant::createNSValueForRange, 15),
        NSAccessibilityBoundsForRangeParameterizedAttribute(AccessibleAttribute.BOUNDS_FOR_RANGE, MacVariant::createNSValueForRectangle, 18);

        long ptr;
        AccessibleAttribute jfxAttr;
        Function<Object, MacVariant> map;
        int inputType;

        private MacAttribute(AccessibleAttribute jfxAttr, Function<Object, MacVariant> map, int inputType) {
            this.jfxAttr = jfxAttr;
            this.map = map;
            this.inputType = inputType;
        }

        private MacAttribute(AccessibleAttribute jfxAttr, Function<Object, MacVariant> map) {
            this.jfxAttr = jfxAttr;
            this.map = map;
        }

        static MacAttribute getAttribute(long ptr) {
            if (ptr == 0L) {
                return null;
            }
            for (MacAttribute attr : MacAttribute.values()) {
                if (ptr != attr.ptr && !MacAccessible.isEqualToString(attr.ptr, ptr)) continue;
                return attr;
            }
            return null;
        }
    }
}

