/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.paint.Color;

public final class Stop {
    static final List<Stop> NO_STOPS = Collections.unmodifiableList(Arrays.asList(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT)));
    private double offset;
    private Color color;
    private int hash = 0;

    static List<Stop> normalize(Stop[] stops) {
        List<Stop> stoplist = stops == null ? null : Arrays.asList(stops);
        return Stop.normalize(stoplist);
    }

    static List<Stop> normalize(List<Stop> stops) {
        if (stops == null) {
            return NO_STOPS;
        }
        Stop zerostop = null;
        Stop onestop = null;
        ArrayList<Stop> newlist = new ArrayList<Stop>(stops.size());
        for (Stop s : stops) {
            if (s == null || s.getColor() == null) continue;
            double off = s.getOffset();
            if (off <= 0.0) {
                if (zerostop != null && !(off >= zerostop.getOffset())) continue;
                zerostop = s;
                continue;
            }
            if (off >= 1.0) {
                if (onestop != null && !(off < onestop.getOffset())) continue;
                onestop = s;
                continue;
            }
            if (off != off) continue;
            for (int i = newlist.size() - 1; i >= 0; --i) {
                Stop s2 = (Stop)newlist.get(i);
                if (!(s2.getOffset() <= off)) continue;
                if (s2.getOffset() == off) {
                    if (i > 0 && ((Stop)newlist.get(i - 1)).getOffset() == off) {
                        newlist.set(i, s);
                    } else {
                        newlist.add(i + 1, s);
                    }
                } else {
                    newlist.add(i + 1, s);
                }
                s = null;
                break;
            }
            if (s == null) continue;
            newlist.add(0, s);
        }
        if (zerostop == null) {
            Color zerocolor;
            if (newlist.isEmpty()) {
                if (onestop == null) {
                    return NO_STOPS;
                }
                zerocolor = onestop.getColor();
            } else {
                zerocolor = ((Stop)newlist.get(0)).getColor();
                if (onestop == null && newlist.size() == 1) {
                    newlist.clear();
                }
            }
            zerostop = new Stop(0.0, zerocolor);
        } else if (zerostop.getOffset() < 0.0) {
            zerostop = new Stop(0.0, zerostop.getColor());
        }
        newlist.add(0, zerostop);
        if (onestop == null) {
            onestop = new Stop(1.0, ((Stop)newlist.get(newlist.size() - 1)).getColor());
        } else if (onestop.getOffset() > 1.0) {
            onestop = new Stop(1.0, onestop.getColor());
        }
        newlist.add(onestop);
        return Collections.unmodifiableList(newlist);
    }

    public final double getOffset() {
        return this.offset;
    }

    public final Color getColor() {
        return this.color;
    }

    public Stop(@NamedArg(value="offset") double offset, @NamedArg(value="color", defaultValue="BLACK") Color color) {
        this.offset = offset;
        this.color = color;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Stop) {
            Stop other = (Stop)obj;
            return this.offset == other.offset && (this.color == null ? other.color == null : this.color.equals(other.color));
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 17L;
            bits = 37L * bits + Double.doubleToLongBits(this.offset);
            bits = 37L * bits + (long)this.color.hashCode();
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return this.color + " " + this.offset * 100.0 + "%";
    }
}

