/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class IOUtils {
    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        File[] children;
        boolean ret = true;
        if (!path.exists()) {
            return true;
        }
        if (path.isDirectory() && (children = path.listFiles()) != null) {
            for (File f : children) {
                ret = ret && IOUtils.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public static void copyFromURL(URL location, File file) throws IOException {
        int len;
        if (location == null) {
            throw new IOException("Missing input resource!");
        }
        if (file.exists()) {
            file.delete();
        }
        InputStream in = location.openStream();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
        file.setReadOnly();
        file.setReadable(true, false);
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        destFile.delete();
        destFile.createNewFile();
        FileChannel source = null;
        FileChannel destination = null;
        source = new FileInputStream(sourceFile).getChannel();
        destination = new FileOutputStream(destFile).getChannel();
        if (destination != null && source != null) {
            destination.transferFrom(source, 0L, source.size());
        }
        if (source != null) {
            source.close();
        }
        if (destination != null) {
            destination.close();
        }
        if (sourceFile.canExecute()) {
            destFile.setExecutable(true, false);
        }
        if (!sourceFile.canWrite()) {
            destFile.setReadOnly();
        }
        destFile.setReadable(true, false);
    }

    public static long getFolderSize(File folder) {
        long foldersize = 0L;
        File[] children = folder.listFiles();
        if (children != null) {
            for (File f : children) {
                if (f.isDirectory()) {
                    foldersize += IOUtils.getFolderSize(f);
                    continue;
                }
                foldersize += f.length();
            }
        }
        return foldersize;
    }

    public static void run(String launcher, File paramFile, boolean verbose) throws IOException {
        if (paramFile != null && paramFile.exists()) {
            ProcessBuilder pb = new ProcessBuilder(launcher, paramFile.getName());
            pb = pb.directory(paramFile.getParentFile());
            IOUtils.exec(pb, verbose);
        }
    }

    public static void exec(ProcessBuilder pb, boolean verbose) throws IOException {
        IOUtils.exec(pb, verbose, false);
    }

    public static void exec(ProcessBuilder pb, boolean verbose, boolean testForPresenseOnly) throws IOException {
        IOUtils.exec(pb, verbose, testForPresenseOnly, null);
    }

    public static void exec(ProcessBuilder pb, boolean verbose, boolean testForPresenseOnly, PrintStream consumer) throws IOException {
        String lineRead;
        pb.redirectErrorStream(true);
        Log.verbose("Running " + Arrays.toString(pb.command().toArray(new String[0])) + (pb.directory() != null ? " in " + pb.directory() : ""));
        Process p = pb.start();
        InputStreamReader isr = new InputStreamReader(p.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        while ((lineRead = br.readLine()) != null) {
            if (consumer != null) {
                consumer.print(lineRead);
                continue;
            }
            if (verbose) {
                Log.info(lineRead);
                continue;
            }
            Log.debug(lineRead);
        }
        try {
            int ret = p.waitFor();
            if (!(ret == 0 || testForPresenseOnly && ret != 127)) {
                throw new IOException("Exec failed with code " + ret + " command [" + Arrays.toString(pb.command().toArray(new String[0])) + " in " + (pb.directory() != null ? pb.directory().getAbsolutePath() : "unspecified directory"));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isNotSymbolicLink(File file) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return true;
        }
        try {
            if (file == null || file.getParent() == null) {
                return false;
            }
            File file_canonical = new File(file.getParentFile().getCanonicalFile(), file.getName());
            if (file_canonical.getCanonicalFile().equals(file_canonical.getAbsoluteFile())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static byte[] readFully(File f) throws IOException {
        FileInputStream inp = new FileInputStream(f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = ((InputStream)inp).read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        baos.close();
        return baos.toByteArray();
    }
}

