/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public abstract class BaseIntToByteConverter
implements IntToBytePixelConverter {
    protected final IntPixelGetter getter;
    protected final BytePixelSetter setter;
    protected final int nDstElems;

    BaseIntToByteConverter(IntPixelGetter getter, BytePixelSetter setter) {
        this.getter = getter;
        this.setter = setter;
        this.nDstElems = setter.getNumElements();
    }

    public final IntPixelGetter getGetter() {
        return this.getter;
    }

    public final BytePixelSetter getSetter() {
        return this.setter;
    }

    abstract void doConvert(int[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, int var8);

    abstract void doConvert(IntBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8);

    @Override
    public final void convert(int[] srcarr, int srcoff, int srcscanints, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanints == w && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        this.doConvert(srcarr, srcoff, srcscanints, dstarr, dstoff, dstscanbytes, w, h);
    }

    @Override
    public final void convert(IntBuffer srcbuf, int srcoff, int srcscanints, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanints == w && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray() && dstbuf.hasArray()) {
            this.doConvert(srcbuf.array(), srcoff += srcbuf.arrayOffset(), srcscanints, dstbuf.array(), dstoff += dstbuf.arrayOffset(), dstscanbytes, w, h);
        } else {
            this.doConvert(srcbuf, srcoff, srcscanints, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }

    @Override
    public final void convert(IntBuffer srcbuf, int srcoff, int srcscanints, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanints == w && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray()) {
            int[] srcarr = srcbuf.array();
            this.doConvert(srcarr, srcoff += srcbuf.arrayOffset(), srcscanints, dstarr, dstoff, dstscanbytes, w, h);
        } else {
            ByteBuffer dstbuf = ByteBuffer.wrap(dstarr);
            this.doConvert(srcbuf, srcoff, srcscanints, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }

    @Override
    public final void convert(int[] srcarr, int srcoff, int srcscanints, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanints == w && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (dstbuf.hasArray()) {
            byte[] dstarr = dstbuf.array();
            this.doConvert(srcarr, srcoff, srcscanints, dstarr, dstoff += dstbuf.arrayOffset(), dstscanbytes, w, h);
        } else {
            IntBuffer srcbuf = IntBuffer.wrap(srcarr);
            this.doConvert(srcbuf, srcoff, srcscanints, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }
}

