/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import java.util.Arrays;
import java.util.List;

public interface ImageFormatDescription {
    public String getFormatName();

    public List<String> getExtensions();

    public List<Signature> getSignatures();

    public static final class Signature {
        private final byte[] bytes;

        public Signature(byte ... bytes) {
            this.bytes = bytes;
        }

        public int getLength() {
            return this.bytes.length;
        }

        public boolean matches(byte[] streamBytes) {
            if (streamBytes.length < this.bytes.length) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (streamBytes[i] == this.bytes[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Signature)) {
                return false;
            }
            return Arrays.equals(this.bytes, ((Signature)other).bytes);
        }
    }
}

