/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.InputFieldSkin;
import com.sun.javafx.scene.control.skin.IntegerField;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;

public class IntegerFieldSkin
extends InputFieldSkin {
    private InvalidationListener integerFieldValueListener = observable -> this.updateText();

    public IntegerFieldSkin(IntegerField control) {
        super(control);
        control.valueProperty().addListener(this.integerFieldValueListener);
    }

    @Override
    public IntegerField getSkinnable() {
        return (IntegerField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((IntegerField)this.control).valueProperty().removeListener(this.integerFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String text) {
        if (text.length() == 0) {
            return true;
        }
        if (text.matches("[0-9]*")) {
            try {
                Integer.parseInt(text);
                int value = Integer.parseInt(text);
                int maxValue = ((IntegerField)this.control).getMaxValue();
                return maxValue != -1 ? value <= maxValue : true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void updateText() {
        this.getTextField().setText("" + ((IntegerField)this.control).getValue());
    }

    @Override
    protected void updateValue() {
        int value = ((IntegerField)this.control).getValue();
        String text = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim();
        try {
            int newValue = Integer.parseInt(text);
            if (newValue != value) {
                ((IntegerField)this.control).setValue(newValue);
            }
        }
        catch (NumberFormatException ex) {
            ((IntegerField)this.control).setValue(0);
            Platform.runLater(() -> this.getTextField().positionCaret(1));
        }
    }
}

