/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import java.util.Collection;
import java.util.Vector;

class GestureRecognizers
implements GestureRecognizer {
    private Collection<GestureRecognizer> recognizers = new Vector<GestureRecognizer>();
    private GestureRecognizer[] workList;

    GestureRecognizers() {
    }

    void add(GestureRecognizer r) {
        if (!this.contains(r)) {
            this.recognizers.add(r);
            this.workList = null;
        }
    }

    void remove(GestureRecognizer r) {
        if (this.contains(r)) {
            this.recognizers.remove(r);
            this.workList = null;
        }
    }

    boolean contains(GestureRecognizer r) {
        return this.recognizers.contains(r);
    }

    private GestureRecognizer[] synchWorkList() {
        if (this.workList == null) {
            this.workList = this.recognizers.toArray(new GestureRecognizer[0]);
        }
        return this.workList;
    }

    @Override
    public void notifyBeginTouchEvent(long time, int modifiers, boolean isDirect, int touchEventCount) {
        GestureRecognizer[] wl = this.synchWorkList();
        for (int idx = 0; idx != wl.length; ++idx) {
            wl[idx].notifyBeginTouchEvent(time, modifiers, isDirect, touchEventCount);
        }
    }

    @Override
    public void notifyNextTouchEvent(long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        GestureRecognizer[] wl = this.synchWorkList();
        for (int idx = 0; idx != wl.length; ++idx) {
            wl[idx].notifyNextTouchEvent(time, type, touchId, x, y, xAbs, yAbs);
        }
    }

    @Override
    public void notifyEndTouchEvent(long time) {
        GestureRecognizer[] wl = this.synchWorkList();
        for (int idx = 0; idx != wl.length; ++idx) {
            wl[idx].notifyEndTouchEvent(time);
        }
    }
}

