/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.DatePickerSkin;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.LocalDateStringConverter;

public class DatePicker
extends ComboBoxBase<LocalDate> {
    private LocalDate lastValidDate = null;
    private Chronology lastValidChronology = IsoChronology.INSTANCE;
    private ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactory;
    private ObjectProperty<Chronology> chronology = new SimpleObjectProperty<Object>(this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty<Object>(this, "converter", null);
    private StringConverter<LocalDate> defaultConverter = new LocalDateStringConverter(FormatStyle.SHORT, null, this.getChronology());
    private ReadOnlyObjectWrapper<TextField> editor;
    private static final String DEFAULT_STYLE_CLASS = "date-picker";

    public DatePicker() {
        this(null);
        this.valueProperty().addListener(observable -> {
            LocalDate date = (LocalDate)this.getValue();
            Chronology chrono = this.getChronology();
            if (this.validateDate(chrono, date)) {
                this.lastValidDate = date;
            } else {
                System.err.println("Restoring value to " + (this.lastValidDate == null ? "null" : this.getConverter().toString(this.lastValidDate)));
                this.setValue(this.lastValidDate);
            }
        });
        this.chronologyProperty().addListener(observable -> {
            LocalDate date = (LocalDate)this.getValue();
            Chronology chrono = this.getChronology();
            if (this.validateDate(chrono, date)) {
                this.lastValidChronology = chrono;
                this.defaultConverter = new LocalDateStringConverter(FormatStyle.SHORT, null, chrono);
            } else {
                System.err.println("Restoring value to " + this.lastValidChronology);
                this.setChronology(this.lastValidChronology);
            }
        });
    }

    private boolean validateDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException ex) {
            System.err.println(ex);
            return false;
        }
    }

    public DatePicker(LocalDate localDate) {
        this.setValue(localDate);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.DATE_PICKER);
        this.setEditable(true);
    }

    public final void setDayCellFactory(Callback<DatePicker, DateCell> value) {
        this.dayCellFactoryProperty().set(value);
    }

    public final Callback<DatePicker, DateCell> getDayCellFactory() {
        return this.dayCellFactory != null ? (Callback)this.dayCellFactory.get() : null;
    }

    public final ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty<Callback<DatePicker, DateCell>>(this, "dayCellFactory");
        }
        return this.dayCellFactory;
    }

    public final ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chrono = (Chronology)this.chronology.get();
        if (chrono == null) {
            try {
                chrono = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            if (chrono == null) {
                chrono = IsoChronology.INSTANCE;
            }
        }
        return chrono;
    }

    public final void setChronology(Chronology value) {
        this.chronology.setValue(value);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            String country = Locale.getDefault(Locale.Category.FORMAT).getCountry();
            boolean localizedDefault = !country.isEmpty() && ControlResources.getNonTranslatableString("DatePicker.showWeekNumbers").contains(country);
            this.showWeekNumbers = new StyleableBooleanProperty(localizedDefault){

                @Override
                public CssMetaData<DatePicker, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEK_NUMBERS;
                }

                @Override
                public Object getBean() {
                    return DatePicker.this;
                }

                @Override
                public String getName() {
                    return "showWeekNumbers";
                }
            };
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean value) {
        this.showWeekNumbersProperty().setValue(value);
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    public final ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<LocalDate> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<LocalDate> getConverter() {
        StringConverter converter = (StringConverter)this.converterProperty().get();
        if (converter != null) {
            return converter;
        }
        return this.defaultConverter;
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.editor.set(new ComboBoxPopupControl.FakeFocusTextField());
        }
        return this.editor.getReadOnlyProperty();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new DatePickerSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DatePicker.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case DATE: {
                return this.getValue();
            }
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                LocalDate date = (LocalDate)this.getValue();
                StringConverter<LocalDate> c = this.getConverter();
                if (date != null && c != null) {
                    return c.toString(date);
                }
                return "";
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private static class StyleableProperties {
        private static final String country = Locale.getDefault(Locale.Category.FORMAT).getCountry();
        private static final CssMetaData<DatePicker, Boolean> SHOW_WEEK_NUMBERS = new CssMetaData<DatePicker, Boolean>("-fx-show-week-numbers", BooleanConverter.getInstance(), Boolean.valueOf(!country.isEmpty() && ControlResources.getNonTranslatableString("DatePicker.showWeekNumbers").contains(country))){

            @Override
            public boolean isSettable(DatePicker n) {
                return n.showWeekNumbers == null || !n.showWeekNumbers.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(DatePicker n) {
                return (StyleableProperty)((Object)n.showWeekNumbersProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SHOW_WEEK_NUMBERS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

